/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.io.EOFException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import zipkin2.Span;
import zipkin2.internal.Buffer;
import zipkin2.internal.Nullable;
import zipkin2.internal.ThriftField;
import zipkin2.internal.V1ThriftSpanReader;
import zipkin2.internal.V1ThriftSpanWriter;
import zipkin2.v1.V1Span;
import zipkin2.v1.V1SpanConverter;

public final class ThriftCodec {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final int MAX_SKIP_DEPTH = Integer.MAX_VALUE;
    final V1ThriftSpanWriter writer = new V1ThriftSpanWriter();

    public int sizeInBytes(Span input) {
        return this.writer.sizeInBytes(input);
    }

    public byte[] write(Span span) {
        return this.writer.write(span);
    }

    public byte[] writeList(List<Span> spans) {
        return this.writer.writeList(spans);
    }

    public int writeList(List<Span> spans, byte[] out, int pos) {
        return this.writer.writeList(spans, out, pos);
    }

    static <T> int listSizeInBytes(Buffer.Writer<T> writer, List<T> values) {
        int sizeInBytes = 5;
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            sizeInBytes += writer.sizeInBytes(values.get(i));
        }
        return sizeInBytes;
    }

    public static boolean read(byte[] bytes, Collection<Span> out) {
        if (bytes.length == 0) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            V1Span v1Span = new V1ThriftSpanReader().read(buffer);
            V1SpanConverter.create().convert(v1Span, out);
            return true;
        }
        catch (Exception e) {
            throw ThriftCodec.exceptionReading("Span", e);
        }
    }

    @Nullable
    public static Span readOne(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            V1Span v1Span = new V1ThriftSpanReader().read(buffer);
            ArrayList<Span> out = new ArrayList<Span>(1);
            V1SpanConverter.create().convert(v1Span, out);
            return (Span)out.get(0);
        }
        catch (Exception e) {
            throw ThriftCodec.exceptionReading("Span", e);
        }
    }

    public static boolean readList(byte[] bytes, Collection<Span> out) {
        int length = bytes.length;
        if (length == 0) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        try {
            int listLength = ThriftCodec.readListLength(buffer);
            if (listLength == 0) {
                return false;
            }
            V1ThriftSpanReader reader = new V1ThriftSpanReader();
            V1SpanConverter converter = V1SpanConverter.create();
            for (int i = 0; i < listLength; ++i) {
                V1Span v1Span = reader.read(buffer);
                converter.convert(v1Span, out);
            }
        }
        catch (Exception e) {
            throw ThriftCodec.exceptionReading("List<Span>", e);
        }
        return true;
    }

    static int readListLength(ByteBuffer bytes) {
        byte ignoredType = bytes.get();
        return ThriftCodec.guardLength(bytes);
    }

    static <T> void writeList(Buffer.Writer<T> writer, List<T> value, Buffer buffer) {
        int length = value.size();
        ThriftCodec.writeListBegin(buffer, length);
        for (int i = 0; i < length; ++i) {
            writer.write(value.get(i), buffer);
        }
    }

    static IllegalArgumentException exceptionReading(String type, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (e instanceof EOFException) {
            cause = "EOF";
        }
        if (e instanceof IllegalStateException || e instanceof BufferUnderflowException) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from TBinary", cause, type);
        throw new IllegalArgumentException(message, e);
    }

    static void skip(ByteBuffer bytes, byte type) {
        ThriftCodec.skip(bytes, type, Integer.MAX_VALUE);
    }

    static void skip(ByteBuffer bytes, byte type, int maxDepth) {
        if (maxDepth <= 0) {
            throw new IllegalStateException("Maximum skip depth exceeded");
        }
        switch (type) {
            case 2: 
            case 3: {
                ThriftCodec.skip(bytes, 1);
                break;
            }
            case 6: {
                ThriftCodec.skip(bytes, 2);
                break;
            }
            case 8: {
                ThriftCodec.skip(bytes, 4);
                break;
            }
            case 4: 
            case 10: {
                ThriftCodec.skip(bytes, 8);
                break;
            }
            case 11: {
                int size = ThriftCodec.guardLength(bytes);
                ThriftCodec.skip(bytes, size);
                break;
            }
            case 12: {
                while (true) {
                    ThriftField thriftField = ThriftField.read(bytes);
                    if (thriftField.type == 0) {
                        return;
                    }
                    ThriftCodec.skip(bytes, thriftField.type, maxDepth - 1);
                }
            }
            case 13: {
                byte keyType = bytes.get();
                byte valueType = bytes.get();
                int length = ThriftCodec.guardLength(bytes);
                for (int i = 0; i < length; ++i) {
                    ThriftCodec.skip(bytes, keyType, maxDepth - 1);
                    ThriftCodec.skip(bytes, valueType, maxDepth - 1);
                }
                break;
            }
            case 14: 
            case 15: {
                byte elemType = bytes.get();
                int length = ThriftCodec.guardLength(bytes);
                for (int i = 0; i < length; ++i) {
                    ThriftCodec.skip(bytes, elemType, maxDepth - 1);
                }
                break;
            }
        }
    }

    static void skip(ByteBuffer bytes, int count) {
        for (int i = 0; i < count && bytes.hasRemaining(); ++i) {
            bytes.get();
        }
    }

    static byte[] readByteArray(ByteBuffer bytes) {
        byte[] result = new byte[ThriftCodec.guardLength(bytes)];
        bytes.get(result);
        return result;
    }

    static String readUtf8(ByteBuffer bytes) {
        return new String(ThriftCodec.readByteArray(bytes), UTF_8);
    }

    static int guardLength(ByteBuffer buffer) {
        int length = buffer.getInt();
        if (length > buffer.remaining()) {
            throw new IllegalArgumentException("Truncated: length " + length + " > bytes remaining " + buffer.remaining());
        }
        return length;
    }

    static void writeListBegin(Buffer buffer, int size) {
        buffer.writeByte(12);
        ThriftCodec.writeInt(buffer, size);
    }

    static void writeLengthPrefixed(Buffer buffer, String utf8) {
        int length = Buffer.utf8SizeInBytes(utf8);
        ThriftCodec.writeInt(buffer, Buffer.utf8SizeInBytes(utf8));
        buffer.writeUtf8(utf8);
    }

    static void writeInt(Buffer buf, int v) {
        buf.writeByte((byte)(v >>> 24 & 0xFF));
        buf.writeByte((byte)(v >>> 16 & 0xFF));
        buf.writeByte((byte)(v >>> 8 & 0xFF));
        buf.writeByte((byte)(v & 0xFF));
    }

    static void writeLong(Buffer buf, long v) {
        buf.writeByte((byte)(v >>> 56 & 0xFFL));
        buf.writeByte((byte)(v >>> 48 & 0xFFL));
        buf.writeByte((byte)(v >>> 40 & 0xFFL));
        buf.writeByte((byte)(v >>> 32 & 0xFFL));
        buf.writeByte((byte)(v >>> 24 & 0xFFL));
        buf.writeByte((byte)(v >>> 16 & 0xFFL));
        buf.writeByte((byte)(v >>> 8 & 0xFFL));
        buf.writeByte((byte)(v & 0xFFL));
    }
}

