/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserResult;
import graphql.util.TraverserState;
import graphql.util.TraverserVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@Internal
public class Traverser<T> {
    private final TraverserState<T> traverserState;
    private final Function<? super T, ? extends List<T>> getChildren;
    private final Map<Class<?>, Object> rootVars = new ConcurrentHashMap();
    private static final List<TraversalControl> CONTINUE_OR_QUIT = Arrays.asList(TraversalControl.CONTINUE, TraversalControl.QUIT);

    private Traverser(TraverserState<T> traverserState, Function<? super T, ? extends List<T>> getChildren) {
        this.traverserState = Assert.assertNotNull(traverserState);
        this.getChildren = Assert.assertNotNull(getChildren);
    }

    public Traverser<T> rootVars(Map<Class<?>, Object> rootVars) {
        this.rootVars.putAll(Assert.assertNotNull(rootVars));
        return this;
    }

    public Traverser<T> rootVar(Class<?> key, Object value) {
        this.rootVars.put(key, value);
        return this;
    }

    public static <T> Traverser<T> depthFirst(Function<? super T, ? extends List<T>> getChildren) {
        return Traverser.depthFirst(getChildren, null);
    }

    public static <T> Traverser<T> depthFirst(Function<? super T, ? extends List<T>> getChildren, Object initialData) {
        return new Traverser<T>(TraverserState.newStackState(initialData), getChildren);
    }

    public static <T> Traverser<T> breadthFirst(Function<? super T, ? extends List<T>> getChildren) {
        return Traverser.breadthFirst(getChildren, null);
    }

    public static <T> Traverser<T> breadthFirst(Function<? super T, ? extends List<T>> getChildren, Object initialData) {
        return new Traverser<T>(TraverserState.newQueueState(initialData), getChildren);
    }

    public TraverserResult traverse(T root, TraverserVisitor<? super T> visitor) {
        return this.traverse((Collection<? extends T>)Collections.singleton(root), visitor);
    }

    public TraverserResult traverse(Collection<? extends T> roots, TraverserVisitor<? super T> visitor) {
        Assert.assertNotNull(roots);
        Assert.assertNotNull(visitor);
        this.traverserState.addNewContexts(roots, this.traverserState.newContext(null, null, this.rootVars));
        TraverserContext currentContext = null;
        block9: while (!this.traverserState.isEmpty()) {
            TraversalControl traversalControl;
            Object top = this.traverserState.pop();
            if (top == TraverserState.Marker.END_LIST) {
                TraverserContext contextForLeave;
                currentContext = contextForLeave = (TraverserContext)this.traverserState.pop();
                TraversalControl traversalControl2 = visitor.leave(contextForLeave);
                Assert.assertNotNull(traversalControl2, "result of leave must not be null", new Object[0]);
                Assert.assertTrue(CONTINUE_OR_QUIT.contains((Object)traversalControl2), "result can only return CONTINUE or QUIT", new Object[0]);
                switch (traversalControl2) {
                    case QUIT: {
                        break block9;
                    }
                    case CONTINUE: {
                        continue block9;
                    }
                    default: {
                        Assert.assertShouldNeverHappen();
                    }
                }
            }
            if ((currentContext = (TraverserContext)top).isVisited()) {
                traversalControl = visitor.backRef(currentContext);
                Assert.assertNotNull(traversalControl, "result of backRef must not be null", new Object[0]);
                Assert.assertTrue(CONTINUE_OR_QUIT.contains((Object)traversalControl), "backRef can only return CONTINUE or QUIT", new Object[0]);
                if (traversalControl != TraversalControl.QUIT) continue;
                break;
            }
            traversalControl = visitor.enter(currentContext);
            Assert.assertNotNull(traversalControl, "result of enter must not be null", new Object[0]);
            this.traverserState.addVisited(currentContext.thisNode());
            switch (traversalControl) {
                case QUIT: {
                    break block9;
                }
                case ABORT: {
                    continue block9;
                }
                case CONTINUE: {
                    this.traverserState.pushAll(currentContext, this.getChildren);
                    continue block9;
                }
                default: {
                    Assert.assertShouldNeverHappen();
                }
            }
        }
        TraverserResult traverserResult = new TraverserResult(currentContext.getResult());
        return traverserResult;
    }
}

