/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Scalars;
import graphql.language.ScalarTypeDefinition;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScalarInfo {
    public static final List<GraphQLScalarType> STANDARD_SCALARS = new ArrayList<GraphQLScalarType>();
    public static final List<GraphQLScalarType> GRAPHQL_SPECIFICATION_SCALARS = new ArrayList<GraphQLScalarType>();
    public static final Map<String, ScalarTypeDefinition> STANDARD_SCALAR_DEFINITIONS = new LinkedHashMap<String, ScalarTypeDefinition>();

    public static boolean isStandardScalar(GraphQLScalarType scalarType) {
        return ScalarInfo.inList(STANDARD_SCALARS, scalarType.getName());
    }

    public static boolean isStandardScalar(String scalarTypeName) {
        return ScalarInfo.inList(STANDARD_SCALARS, scalarTypeName);
    }

    public static boolean isGraphqlSpecifiedScalar(String scalarTypeName) {
        return ScalarInfo.inList(GRAPHQL_SPECIFICATION_SCALARS, scalarTypeName);
    }

    public static boolean isGraphqlSpecifiedScalar(GraphQLScalarType scalarType) {
        return ScalarInfo.inList(GRAPHQL_SPECIFICATION_SCALARS, scalarType.getName());
    }

    private static boolean inList(List<GraphQLScalarType> scalarList, String scalarTypeName) {
        return scalarList.stream().anyMatch(sc -> sc.getName().equals(scalarTypeName));
    }

    static {
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLInt);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLFloat);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLString);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLBoolean);
        GRAPHQL_SPECIFICATION_SCALARS.add(Scalars.GraphQLID);
        STANDARD_SCALARS.add(Scalars.GraphQLInt);
        STANDARD_SCALARS.add(Scalars.GraphQLFloat);
        STANDARD_SCALARS.add(Scalars.GraphQLString);
        STANDARD_SCALARS.add(Scalars.GraphQLBoolean);
        STANDARD_SCALARS.add(Scalars.GraphQLID);
        STANDARD_SCALARS.add(Scalars.GraphQLBigDecimal);
        STANDARD_SCALARS.add(Scalars.GraphQLBigInteger);
        STANDARD_SCALARS.add(Scalars.GraphQLByte);
        STANDARD_SCALARS.add(Scalars.GraphQLChar);
        STANDARD_SCALARS.add(Scalars.GraphQLShort);
        STANDARD_SCALARS.add(Scalars.GraphQLLong);
        STANDARD_SCALAR_DEFINITIONS.put("Int", new ScalarTypeDefinition("Int"));
        STANDARD_SCALAR_DEFINITIONS.put("Float", new ScalarTypeDefinition("Float"));
        STANDARD_SCALAR_DEFINITIONS.put("String", new ScalarTypeDefinition("String"));
        STANDARD_SCALAR_DEFINITIONS.put("Boolean", new ScalarTypeDefinition("Boolean"));
        STANDARD_SCALAR_DEFINITIONS.put("ID", new ScalarTypeDefinition("ID"));
        STANDARD_SCALAR_DEFINITIONS.put("Long", new ScalarTypeDefinition("Long"));
        STANDARD_SCALAR_DEFINITIONS.put("BigInteger", new ScalarTypeDefinition("BigInteger"));
        STANDARD_SCALAR_DEFINITIONS.put("BigDecimal", new ScalarTypeDefinition("BigDecimal"));
        STANDARD_SCALAR_DEFINITIONS.put("Short", new ScalarTypeDefinition("Short"));
        STANDARD_SCALAR_DEFINITIONS.put("Char", new ScalarTypeDefinition("Char"));
    }
}

