/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.language.InputValueDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.SchemaUtil;
import java.util.Map;

@PublicApi
public class GraphQLArgument {
    private final String name;
    private final String description;
    private GraphQLInputType type;
    private final Object defaultValue;
    private final InputValueDefinition definition;

    public GraphQLArgument(String name, String description, GraphQLInputType type, Object defaultValue) {
        this(name, description, type, defaultValue, null);
    }

    public GraphQLArgument(String name, GraphQLInputType type) {
        this(name, null, type, null, null);
    }

    public GraphQLArgument(String name, String description, GraphQLInputType type, Object defaultValue, InputValueDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(type, "type can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.type = type;
        this.defaultValue = defaultValue;
        this.definition = definition;
    }

    void replaceTypeReferences(Map<String, GraphQLType> typeMap) {
        this.type = (GraphQLInputType)new SchemaUtil().resolveTypeReference(this.type, typeMap);
    }

    public String getName() {
        return this.name;
    }

    public GraphQLInputType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public InputValueDefinition getDefinition() {
        return this.definition;
    }

    public static Builder newArgument() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private GraphQLInputType type;
        private Object defaultValue;
        private String description;
        private InputValueDefinition definition;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(InputValueDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder type(GraphQLInputType type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public GraphQLArgument build() {
            return new GraphQLArgument(this.name, this.description, this.type, this.defaultValue, this.definition);
        }
    }
}

