/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionTypeInfo;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class DataFetchingFieldSelectionSetImpl
implements DataFetchingFieldSelectionSet {
    private static final DataFetchingFieldSelectionSet NOOP = new DataFetchingFieldSelectionSet(){

        @Override
        public Map<String, List<Field>> get() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Map<String, Object>> getArguments() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, GraphQLFieldDefinition> getDefinitions() {
            return Collections.emptyMap();
        }

        @Override
        public boolean contains(String fieldGlobPattern) {
            return false;
        }
    };
    private final List<Field> parentFields;
    private final GraphQLSchema graphQLSchema;
    private final GraphQLFieldsContainer parentFieldType;
    private final Map<String, Object> variables;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private Map<String, List<Field>> selectionSetFields;
    private Map<String, GraphQLFieldDefinition> selectionSetFieldDefinitions;
    private Map<String, Map<String, Object>> selectionSetFieldArgs;
    private Set<String> flattenedFields;
    private static final String SEP = "/";

    public static DataFetchingFieldSelectionSet newCollector(ExecutionContext executionContext, GraphQLType fieldType, List<Field> fields) {
        GraphQLType unwrappedType = ExecutionTypeInfo.unwrapBaseType(fieldType);
        if (unwrappedType instanceof GraphQLFieldsContainer) {
            return new DataFetchingFieldSelectionSetImpl(executionContext, (GraphQLFieldsContainer)unwrappedType, fields);
        }
        return NOOP;
    }

    private static GraphQLObjectType asObjectTypeOrNull(GraphQLType unwrappedType) {
        return unwrappedType instanceof GraphQLObjectType ? (GraphQLObjectType)unwrappedType : null;
    }

    private DataFetchingFieldSelectionSetImpl(ExecutionContext executionContext, GraphQLFieldsContainer parentFieldType, List<Field> parentFields) {
        this.parentFields = parentFields;
        this.graphQLSchema = executionContext.getGraphQLSchema();
        this.parentFieldType = parentFieldType;
        this.variables = executionContext.getVariables();
        this.fragmentsByName = executionContext.getFragmentsByName();
    }

    @Override
    public Map<String, List<Field>> get() {
        this.computeValuesLazily();
        return this.selectionSetFields;
    }

    @Override
    public Map<String, Map<String, Object>> getArguments() {
        this.computeValuesLazily();
        return this.selectionSetFieldArgs;
    }

    @Override
    public Map<String, GraphQLFieldDefinition> getDefinitions() {
        this.computeValuesLazily();
        return this.selectionSetFieldDefinitions;
    }

    @Override
    public boolean contains(String fieldGlobPattern) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return false;
        }
        this.computeValuesLazily();
        PathMatcher globMatcher = FileSystems.getDefault().getPathMatcher("glob:" + fieldGlobPattern);
        for (String flattenedField : this.flattenedFields) {
            Path path = Paths.get(flattenedField, new String[0]);
            if (!globMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeValuesLazily() {
        DataFetchingFieldSelectionSetImpl dataFetchingFieldSelectionSetImpl = this;
        synchronized (dataFetchingFieldSelectionSetImpl) {
            if (this.selectionSetFields != null) {
                return;
            }
            this.selectionSetFields = new LinkedHashMap<String, List<Field>>();
            this.selectionSetFieldDefinitions = new LinkedHashMap<String, GraphQLFieldDefinition>();
            this.selectionSetFieldArgs = new LinkedHashMap<String, Map<String, Object>>();
            this.flattenedFields = new LinkedHashSet<String>();
            this.traverseFields(this.parentFields, this.parentFieldType, "");
        }
    }

    private void traverseFields(List<Field> fieldList, GraphQLFieldsContainer parentFieldType, String fieldPrefix) {
        FieldCollector fieldCollector = new FieldCollector();
        ValuesResolver valuesResolver = new ValuesResolver();
        FieldCollectorParameters parameters = FieldCollectorParameters.newParameters().schema(this.graphQLSchema).objectType(DataFetchingFieldSelectionSetImpl.asObjectTypeOrNull(parentFieldType)).fragments(this.fragmentsByName).variables(this.variables).build();
        Map<String, List<Field>> collectedFields = fieldCollector.collectFields(parameters, fieldList);
        for (Map.Entry<String, List<Field>> entry : collectedFields.entrySet()) {
            String fieldName = this.mkFieldName(fieldPrefix, entry.getKey());
            List<Field> collectedFieldList = entry.getValue();
            this.selectionSetFields.put(fieldName, collectedFieldList);
            Field field = collectedFieldList.get(0);
            GraphQLFieldDefinition fieldDef = Introspection.getFieldDef(this.graphQLSchema, (GraphQLCompositeType)((Object)parentFieldType), field.getName());
            GraphQLType unwrappedType = ExecutionTypeInfo.unwrapBaseType(fieldDef.getType());
            Map<String, Object> argumentValues = valuesResolver.getArgumentValues(fieldDef.getArguments(), field.getArguments(), this.variables);
            this.selectionSetFieldArgs.put(fieldName, argumentValues);
            this.selectionSetFieldDefinitions.put(fieldName, fieldDef);
            this.flattenedFields.add(fieldName);
            if (!(unwrappedType instanceof GraphQLFieldsContainer)) continue;
            this.traverseFields(collectedFieldList, (GraphQLFieldsContainer)unwrappedType, fieldName);
        }
    }

    private String mkFieldName(String fieldPrefix, String fieldName) {
        return (!fieldPrefix.isEmpty() ? fieldPrefix + SEP : "") + fieldName;
    }
}

