/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.Internal;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.parser.StringValueParsing;
import graphql.parser.antlr.GraphqlBaseVisitor;
import graphql.parser.antlr.GraphqlParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.RuleNode;

@Internal
public class GraphqlAntlrToLanguage
extends GraphqlBaseVisitor<Void> {
    private final CommonTokenStream tokens;
    private Document result;
    private final Deque<ContextEntry> contextStack = new ArrayDeque<ContextEntry>();

    public GraphqlAntlrToLanguage(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    protected void addContextProperty(ContextProperty contextProperty, Object value) {
        this.contextStack.addFirst(new ContextEntry(contextProperty, value));
    }

    protected void popContext() {
        this.contextStack.removeFirst();
    }

    protected Object getFromContextStack(ContextProperty contextProperty) {
        return this.getFromContextStack(contextProperty, false);
    }

    protected Object getFromContextStack(ContextProperty contextProperty, boolean required) {
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty != contextProperty) continue;
            return contextEntry.value;
        }
        if (required) {
            Assert.assertShouldNeverHappen("not found %s", new Object[]{contextProperty});
        }
        return null;
    }

    @Override
    public Void visitDocument(GraphqlParser.DocumentContext ctx) {
        this.result = new Document();
        this.newNode(this.result, ctx);
        return (Void)super.visitDocument(ctx);
    }

    @Override
    public Void visitOperationDefinition(GraphqlParser.OperationDefinitionContext ctx) {
        OperationDefinition operationDefinition = new OperationDefinition();
        this.newNode(operationDefinition, ctx);
        if (ctx.operationType() == null) {
            operationDefinition.setOperation(OperationDefinition.Operation.QUERY);
        } else {
            operationDefinition.setOperation(this.parseOperation(ctx.operationType()));
        }
        if (ctx.name() != null) {
            operationDefinition.setName(ctx.name().getText());
        }
        this.result.getDefinitions().add(operationDefinition);
        this.addContextProperty(ContextProperty.OperationDefinition, operationDefinition);
        super.visitOperationDefinition(ctx);
        this.popContext();
        return null;
    }

    private OperationDefinition.Operation parseOperation(GraphqlParser.OperationTypeContext operationTypeContext) {
        if (operationTypeContext.getText().equals("query")) {
            return OperationDefinition.Operation.QUERY;
        }
        if (operationTypeContext.getText().equals("mutation")) {
            return OperationDefinition.Operation.MUTATION;
        }
        if (operationTypeContext.getText().equals("subscription")) {
            return OperationDefinition.Operation.SUBSCRIPTION;
        }
        return (OperationDefinition.Operation)((Object)Assert.assertShouldNeverHappen("InternalError: unknown operationTypeContext=%s", operationTypeContext.getText()));
    }

    @Override
    public Void visitFragmentSpread(GraphqlParser.FragmentSpreadContext ctx) {
        FragmentSpread fragmentSpread = new FragmentSpread(ctx.fragmentName().getText());
        this.newNode(fragmentSpread, ctx);
        ((SelectionSet)this.getFromContextStack(ContextProperty.SelectionSet)).getSelections().add(fragmentSpread);
        this.addContextProperty(ContextProperty.FragmentSpread, fragmentSpread);
        super.visitFragmentSpread(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitVariableDefinition(GraphqlParser.VariableDefinitionContext ctx) {
        VariableDefinition variableDefinition = new VariableDefinition();
        this.newNode(variableDefinition, ctx);
        variableDefinition.setName(ctx.variable().name().getText());
        if (ctx.defaultValue() != null) {
            Value value = this.getValue(ctx.defaultValue().value());
            variableDefinition.setDefaultValue(value);
        }
        OperationDefinition operationDefinition = (OperationDefinition)this.getFromContextStack(ContextProperty.OperationDefinition);
        operationDefinition.getVariableDefinitions().add(variableDefinition);
        this.addContextProperty(ContextProperty.VariableDefinition, variableDefinition);
        super.visitVariableDefinition(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitFragmentDefinition(GraphqlParser.FragmentDefinitionContext ctx) {
        FragmentDefinition fragmentDefinition = new FragmentDefinition();
        this.newNode(fragmentDefinition, ctx);
        fragmentDefinition.setName(ctx.fragmentName().getText());
        fragmentDefinition.setTypeCondition(new TypeName(ctx.typeCondition().typeName().getText()));
        this.addContextProperty(ContextProperty.FragmentDefinition, fragmentDefinition);
        this.result.getDefinitions().add(fragmentDefinition);
        super.visitFragmentDefinition(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitSelectionSet(GraphqlParser.SelectionSetContext ctx) {
        SelectionSet newSelectionSet = new SelectionSet();
        this.newNode(newSelectionSet, ctx);
        this.newSelectionSet(newSelectionSet);
        this.addContextProperty(ContextProperty.SelectionSet, newSelectionSet);
        super.visitSelectionSet(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitField(GraphqlParser.FieldContext ctx) {
        Field newField = new Field();
        this.newNode(newField, ctx);
        newField.setName(ctx.name().getText());
        if (ctx.alias() != null) {
            newField.setAlias(ctx.alias().name().getText());
        }
        this.newField(newField);
        this.addContextProperty(ContextProperty.Field, newField);
        super.visitField(ctx);
        this.popContext();
        return null;
    }

    private void newSelectionSet(SelectionSet selectionSet) {
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty == ContextProperty.Field) {
                ((Field)contextEntry.value).setSelectionSet(selectionSet);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.OperationDefinition) {
                ((OperationDefinition)contextEntry.value).setSelectionSet(selectionSet);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FragmentDefinition) {
                ((FragmentDefinition)contextEntry.value).setSelectionSet(selectionSet);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.InlineFragment) continue;
            ((InlineFragment)contextEntry.value).setSelectionSet(selectionSet);
            break;
        }
    }

    private void newField(Field field) {
        ((SelectionSet)this.getFromContextStack(ContextProperty.SelectionSet)).getSelections().add(field);
    }

    @Override
    public Void visitInlineFragment(GraphqlParser.InlineFragmentContext ctx) {
        TypeName typeName = ctx.typeCondition() != null ? new TypeName(ctx.typeCondition().typeName().getText()) : null;
        InlineFragment inlineFragment = new InlineFragment(typeName);
        this.newNode(inlineFragment, ctx);
        ((SelectionSet)this.getFromContextStack(ContextProperty.SelectionSet)).getSelections().add(inlineFragment);
        this.addContextProperty(ContextProperty.InlineFragment, inlineFragment);
        super.visitInlineFragment(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitTypeName(GraphqlParser.TypeNameContext ctx) {
        TypeName typeName = new TypeName(ctx.name().getText());
        this.newNode(typeName, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.value instanceof ListType) {
                ((ListType)contextEntry.value).setType(typeName);
                break;
            }
            if (contextEntry.value instanceof NonNullType) {
                ((NonNullType)contextEntry.value).setType(typeName);
                break;
            }
            if (contextEntry.value instanceof VariableDefinition) {
                ((VariableDefinition)contextEntry.value).setType(typeName);
                break;
            }
            if (contextEntry.value instanceof FieldDefinition) {
                ((FieldDefinition)contextEntry.value).setType(typeName);
                break;
            }
            if (contextEntry.value instanceof InputValueDefinition) {
                ((InputValueDefinition)contextEntry.value).setType(typeName);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.ObjectTypeDefinition) {
                ((ObjectTypeDefinition)contextEntry.value).getImplements().add(typeName);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.UnionTypeDefinition) {
                ((UnionTypeDefinition)contextEntry.value).getMemberTypes().add(typeName);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.OperationTypeDefinition) continue;
            ((OperationTypeDefinition)contextEntry.value).setType(typeName);
            break;
        }
        return (Void)super.visitTypeName(ctx);
    }

    @Override
    public Void visitNonNullType(GraphqlParser.NonNullTypeContext ctx) {
        NonNullType nonNullType = new NonNullType();
        this.newNode(nonNullType, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.value instanceof ListType) {
                ((ListType)contextEntry.value).setType(nonNullType);
                break;
            }
            if (contextEntry.value instanceof VariableDefinition) {
                ((VariableDefinition)contextEntry.value).setType(nonNullType);
                break;
            }
            if (contextEntry.value instanceof FieldDefinition) {
                ((FieldDefinition)contextEntry.value).setType(nonNullType);
                break;
            }
            if (!(contextEntry.value instanceof InputValueDefinition)) continue;
            ((InputValueDefinition)contextEntry.value).setType(nonNullType);
            break;
        }
        this.addContextProperty(ContextProperty.NonNullType, nonNullType);
        super.visitNonNullType(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitListType(GraphqlParser.ListTypeContext ctx) {
        ListType listType = new ListType();
        this.newNode(listType, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.value instanceof ListType) {
                ((ListType)contextEntry.value).setType(listType);
                break;
            }
            if (contextEntry.value instanceof NonNullType) {
                ((NonNullType)contextEntry.value).setType(listType);
                break;
            }
            if (contextEntry.value instanceof VariableDefinition) {
                ((VariableDefinition)contextEntry.value).setType(listType);
                break;
            }
            if (contextEntry.value instanceof FieldDefinition) {
                ((FieldDefinition)contextEntry.value).setType(listType);
                break;
            }
            if (!(contextEntry.value instanceof InputValueDefinition)) continue;
            ((InputValueDefinition)contextEntry.value).setType(listType);
            break;
        }
        this.addContextProperty(ContextProperty.ListType, listType);
        super.visitListType(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitArgument(GraphqlParser.ArgumentContext ctx) {
        Argument argument = new Argument(ctx.name().getText(), this.getValue(ctx.valueWithVariable()));
        this.newNode(argument, ctx);
        if (this.getFromContextStack(ContextProperty.Directive, false) != null) {
            ((Directive)this.getFromContextStack(ContextProperty.Directive)).getArguments().add(argument);
        } else {
            Field field = (Field)this.getFromContextStack(ContextProperty.Field);
            field.getArguments().add(argument);
        }
        return (Void)super.visitArgument(ctx);
    }

    @Override
    public Void visitDirective(GraphqlParser.DirectiveContext ctx) {
        Directive directive = new Directive(ctx.name().getText());
        this.newNode(directive, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty == ContextProperty.Field) {
                ((Field)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FragmentDefinition) {
                ((FragmentDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FragmentSpread) {
                ((FragmentSpread)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.InlineFragment) {
                ((InlineFragment)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.OperationDefinition) {
                ((OperationDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.EnumValueDefinition) {
                ((EnumValueDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.FieldDefinition) {
                ((FieldDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.InputValueDefinition) {
                ((InputValueDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.InterfaceTypeDefinition) {
                ((InterfaceTypeDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.EnumTypeDefinition) {
                ((EnumTypeDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.ObjectTypeDefinition) {
                ((ObjectTypeDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.ScalarTypeDefinition) {
                ((ScalarTypeDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.UnionTypeDefinition) {
                ((UnionTypeDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.InputObjectTypeDefinition) {
                ((InputObjectTypeDefinition)contextEntry.value).getDirectives().add(directive);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.SchemaDefinition) continue;
            ((SchemaDefinition)contextEntry.value).getDirectives().add(directive);
            break;
        }
        this.addContextProperty(ContextProperty.Directive, directive);
        super.visitDirective(ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitSchemaDefinition(GraphqlParser.SchemaDefinitionContext ctx) {
        SchemaDefinition def = new SchemaDefinition();
        this.newNode(def, ctx);
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.SchemaDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitOperationTypeDefinition(GraphqlParser.OperationTypeDefinitionContext ctx) {
        OperationTypeDefinition def = new OperationTypeDefinition(ctx.operationType().getText());
        this.newNode(def, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty != ContextProperty.SchemaDefinition) continue;
            ((SchemaDefinition)contextEntry.value).getOperationTypeDefinitions().add(def);
            break;
        }
        this.addContextProperty(ContextProperty.OperationTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitScalarTypeDefinition(GraphqlParser.ScalarTypeDefinitionContext ctx) {
        ScalarTypeDefinition def = new ScalarTypeDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.ScalarTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitObjectTypeDefinition(GraphqlParser.ObjectTypeDefinitionContext ctx) {
        ObjectTypeDefinition def = new ObjectTypeDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.ObjectTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitFieldDefinition(GraphqlParser.FieldDefinitionContext ctx) {
        FieldDefinition def = new FieldDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty == ContextProperty.InterfaceTypeDefinition) {
                ((InterfaceTypeDefinition)contextEntry.value).getFieldDefinitions().add(def);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.ObjectTypeDefinition) continue;
            ((ObjectTypeDefinition)contextEntry.value).getFieldDefinitions().add(def);
            break;
        }
        this.addContextProperty(ContextProperty.FieldDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitInputValueDefinition(GraphqlParser.InputValueDefinitionContext ctx) {
        InputValueDefinition def = new InputValueDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        if (ctx.defaultValue() != null) {
            def.setDefaultValue(this.getValue(ctx.defaultValue().value()));
        }
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty == ContextProperty.FieldDefinition) {
                ((FieldDefinition)contextEntry.value).getInputValueDefinitions().add(def);
                break;
            }
            if (contextEntry.contextProperty == ContextProperty.InputObjectTypeDefinition) {
                ((InputObjectTypeDefinition)contextEntry.value).getInputValueDefinitions().add(def);
                break;
            }
            if (contextEntry.contextProperty != ContextProperty.DirectiveDefinition) continue;
            ((DirectiveDefinition)contextEntry.value).getInputValueDefinitions().add(def);
            break;
        }
        this.addContextProperty(ContextProperty.InputValueDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitInterfaceTypeDefinition(GraphqlParser.InterfaceTypeDefinitionContext ctx) {
        InterfaceTypeDefinition def = new InterfaceTypeDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.InterfaceTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitUnionTypeDefinition(GraphqlParser.UnionTypeDefinitionContext ctx) {
        UnionTypeDefinition def = new UnionTypeDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.UnionTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitEnumTypeDefinition(GraphqlParser.EnumTypeDefinitionContext ctx) {
        EnumTypeDefinition def = new EnumTypeDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.EnumTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitEnumValueDefinition(GraphqlParser.EnumValueDefinitionContext ctx) {
        EnumValueDefinition def = new EnumValueDefinition(ctx.enumValue().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty != ContextProperty.EnumTypeDefinition) continue;
            ((EnumTypeDefinition)contextEntry.value).getEnumValueDefinitions().add(def);
            break;
        }
        this.addContextProperty(ContextProperty.EnumValueDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitInputObjectTypeDefinition(GraphqlParser.InputObjectTypeDefinitionContext ctx) {
        InputObjectTypeDefinition def = new InputObjectTypeDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.InputObjectTypeDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    private Void extensionTypeImpl(ParserRuleContext ctx, Definition def, ContextProperty ctxProperty) {
        this.newNode((AbstractNode)((Object)def), ctx);
        this.result.getDefinitions().add(def);
        this.addContextProperty(ctxProperty, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitObjectTypeExtensionDefinition(GraphqlParser.ObjectTypeExtensionDefinitionContext ctx) {
        return this.extensionTypeImpl(ctx, new ObjectTypeExtensionDefinition(ctx.name().getText()), ContextProperty.ObjectTypeDefinition);
    }

    @Override
    public Void visitInterfaceTypeExtensionDefinition(GraphqlParser.InterfaceTypeExtensionDefinitionContext ctx) {
        return this.extensionTypeImpl(ctx, new InterfaceTypeExtensionDefinition(ctx.name().getText()), ContextProperty.InterfaceTypeDefinition);
    }

    @Override
    public Void visitUnionTypeExtensionDefinition(GraphqlParser.UnionTypeExtensionDefinitionContext ctx) {
        return this.extensionTypeImpl(ctx, new UnionTypeExtensionDefinition(ctx.name().getText()), ContextProperty.UnionTypeDefinition);
    }

    @Override
    public Void visitEnumTypeExtensionDefinition(GraphqlParser.EnumTypeExtensionDefinitionContext ctx) {
        return this.extensionTypeImpl(ctx, new EnumTypeExtensionDefinition(ctx.name().getText()), ContextProperty.EnumTypeDefinition);
    }

    @Override
    public Void visitScalarTypeExtensionDefinition(GraphqlParser.ScalarTypeExtensionDefinitionContext ctx) {
        return this.extensionTypeImpl(ctx, new ScalarTypeExtensionDefinition(ctx.name().getText()), ContextProperty.ScalarTypeDefinition);
    }

    @Override
    public Void visitInputObjectTypeExtensionDefinition(GraphqlParser.InputObjectTypeExtensionDefinitionContext ctx) {
        return this.extensionTypeImpl(ctx, new InputObjectTypeExtensionDefinition(ctx.name().getText()), ContextProperty.InputObjectTypeDefinition);
    }

    @Override
    public Void visitDirectiveDefinition(GraphqlParser.DirectiveDefinitionContext ctx) {
        DirectiveDefinition def = new DirectiveDefinition(ctx.name().getText());
        this.newNode(def, ctx);
        def.setDescription(this.newDescription(ctx.description()));
        this.result.getDefinitions().add(def);
        this.addContextProperty(ContextProperty.DirectiveDefinition, def);
        super.visitChildren((RuleNode)ctx);
        this.popContext();
        return null;
    }

    @Override
    public Void visitDirectiveLocation(GraphqlParser.DirectiveLocationContext ctx) {
        DirectiveLocation def = new DirectiveLocation(ctx.name().getText());
        this.newNode(def, ctx);
        for (ContextEntry contextEntry : this.contextStack) {
            if (contextEntry.contextProperty != ContextProperty.DirectiveDefinition) continue;
            ((DirectiveDefinition)contextEntry.value).getDirectiveLocations().add(def);
            break;
        }
        super.visitChildren((RuleNode)ctx);
        return null;
    }

    private Value getValue(GraphqlParser.ValueWithVariableContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue intValue = new IntValue(new BigInteger(ctx.IntValue().getText()));
            this.newNode(intValue, ctx);
            return intValue;
        }
        if (ctx.FloatValue() != null) {
            FloatValue floatValue = new FloatValue(new BigDecimal(ctx.FloatValue().getText()));
            this.newNode(floatValue, ctx);
            return floatValue;
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue booleanValue = new BooleanValue(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.newNode(booleanValue, ctx);
            return booleanValue;
        }
        if (ctx.NullValue() != null) {
            this.newNode(NullValue.Null, ctx);
            return NullValue.Null;
        }
        if (ctx.stringValue() != null) {
            StringValue stringValue = new StringValue(GraphqlAntlrToLanguage.quotedString(ctx.stringValue()));
            this.newNode(stringValue, ctx);
            return stringValue;
        }
        if (ctx.enumValue() != null) {
            EnumValue enumValue = new EnumValue(ctx.enumValue().getText());
            this.newNode(enumValue, ctx);
            return enumValue;
        }
        if (ctx.arrayValueWithVariable() != null) {
            ArrayValue arrayValue = new ArrayValue();
            this.newNode(arrayValue, ctx);
            for (GraphqlParser.ValueWithVariableContext valueWithVariableContext : ctx.arrayValueWithVariable().valueWithVariable()) {
                arrayValue.getValues().add(this.getValue(valueWithVariableContext));
            }
            return arrayValue;
        }
        if (ctx.objectValueWithVariable() != null) {
            ObjectValue objectValue = new ObjectValue();
            this.newNode(objectValue, ctx);
            for (GraphqlParser.ObjectFieldWithVariableContext objectFieldWithVariableContext : ctx.objectValueWithVariable().objectFieldWithVariable()) {
                ObjectField objectField = new ObjectField(objectFieldWithVariableContext.name().getText(), this.getValue(objectFieldWithVariableContext.valueWithVariable()));
                objectValue.getObjectFields().add(objectField);
            }
            return objectValue;
        }
        if (ctx.variable() != null) {
            VariableReference variableReference = new VariableReference(ctx.variable().name().getText());
            this.newNode(variableReference, ctx);
            return variableReference;
        }
        return (Value)Assert.assertShouldNeverHappen();
    }

    private Value getValue(GraphqlParser.ValueContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue intValue = new IntValue(new BigInteger(ctx.IntValue().getText()));
            this.newNode(intValue, ctx);
            return intValue;
        }
        if (ctx.FloatValue() != null) {
            FloatValue floatValue = new FloatValue(new BigDecimal(ctx.FloatValue().getText()));
            this.newNode(floatValue, ctx);
            return floatValue;
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue booleanValue = new BooleanValue(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.newNode(booleanValue, ctx);
            return booleanValue;
        }
        if (ctx.NullValue() != null) {
            this.newNode(NullValue.Null, ctx);
            return NullValue.Null;
        }
        if (ctx.stringValue() != null) {
            StringValue stringValue = new StringValue(GraphqlAntlrToLanguage.quotedString(ctx.stringValue()));
            this.newNode(stringValue, ctx);
            return stringValue;
        }
        if (ctx.enumValue() != null) {
            EnumValue enumValue = new EnumValue(ctx.enumValue().getText());
            this.newNode(enumValue, ctx);
            return enumValue;
        }
        if (ctx.arrayValue() != null) {
            ArrayValue arrayValue = new ArrayValue();
            this.newNode(arrayValue, ctx);
            for (GraphqlParser.ValueContext valueWithVariableContext : ctx.arrayValue().value()) {
                arrayValue.getValues().add(this.getValue(valueWithVariableContext));
            }
            return arrayValue;
        }
        if (ctx.objectValue() != null) {
            ObjectValue objectValue = new ObjectValue();
            this.newNode(objectValue, ctx);
            for (GraphqlParser.ObjectFieldContext objectFieldContext : ctx.objectValue().objectField()) {
                ObjectField objectField = new ObjectField(objectFieldContext.name().getText(), this.getValue(objectFieldContext.value()));
                objectValue.getObjectFields().add(objectField);
            }
            return objectValue;
        }
        return (Value)Assert.assertShouldNeverHappen();
    }

    static String quotedString(GraphqlParser.StringValueContext ctx) {
        boolean multiLine = ctx.TripleQuotedStringValue() != null;
        String strText = ctx.getText();
        if (multiLine) {
            return StringValueParsing.parseTripleQuotedString(strText);
        }
        return StringValueParsing.parseSingleQuotedString(strText);
    }

    private void newNode(AbstractNode abstractNode, ParserRuleContext parserRuleContext) {
        List<Comment> comments = this.getComments(parserRuleContext);
        if (!comments.isEmpty()) {
            abstractNode.setComments(comments);
        }
        abstractNode.setSourceLocation(this.getSourceLocation(parserRuleContext));
    }

    private Description newDescription(GraphqlParser.DescriptionContext descriptionCtx) {
        if (descriptionCtx == null) {
            return null;
        }
        GraphqlParser.StringValueContext stringValueCtx = descriptionCtx.stringValue();
        if (stringValueCtx == null) {
            return null;
        }
        boolean multiLine = stringValueCtx.TripleQuotedStringValue() != null;
        String content = stringValueCtx.getText();
        content = multiLine ? StringValueParsing.parseTripleQuotedString(content) : StringValueParsing.parseSingleQuotedString(content);
        SourceLocation sourceLocation = this.getSourceLocation(descriptionCtx);
        return new Description(content, sourceLocation, multiLine);
    }

    private SourceLocation getSourceLocation(ParserRuleContext parserRuleContext) {
        return new SourceLocation(parserRuleContext.getStart().getLine(), parserRuleContext.getStart().getCharPositionInLine() + 1);
    }

    private List<Comment> getComments(ParserRuleContext ctx) {
        int tokPos;
        List refChannel;
        Token start = ctx.getStart();
        if (start != null && (refChannel = this.tokens.getHiddenTokensToLeft(tokPos = start.getTokenIndex(), 2)) != null) {
            return this.getCommentOnChannel(refChannel);
        }
        return Collections.emptyList();
    }

    private List<Comment> getCommentOnChannel(List<Token> refChannel) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Token refTok : refChannel) {
            String text = refTok.getText();
            if (text == null) continue;
            text = text.replaceFirst("^#", "");
            comments.add(new Comment(text, new SourceLocation(refTok.getLine(), refTok.getCharPositionInLine())));
        }
        return comments;
    }

    public Document getResult() {
        return this.result;
    }

    protected void setResult(Document result) {
        this.result = result;
    }

    public Deque<ContextEntry> getContextStack() {
        return this.contextStack;
    }

    protected static class ContextEntry {
        public final ContextProperty contextProperty;
        public final Object value;

        public ContextEntry(ContextProperty contextProperty, Object value) {
            this.contextProperty = contextProperty;
            this.value = value;
        }
    }

    protected static enum ContextProperty {
        OperationDefinition,
        FragmentDefinition,
        Field,
        InlineFragment,
        FragmentSpread,
        SelectionSet,
        VariableDefinition,
        ListType,
        NonNullType,
        Directive,
        EnumTypeDefinition,
        ObjectTypeDefinition,
        InputObjectTypeDefinition,
        ScalarTypeDefinition,
        UnionTypeDefinition,
        InterfaceTypeDefinition,
        EnumValueDefinition,
        FieldDefinition,
        InputValueDefinition,
        SchemaDefinition,
        OperationTypeDefinition,
        DirectiveDefinition;

    }
}

