/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnionTypeDefinition
extends AbstractNode<UnionTypeDefinition>
implements TypeDefinition<UnionTypeDefinition> {
    private final String name;
    private Description description;
    private final List<Directive> directives;
    private final List<Type> memberTypes;

    public UnionTypeDefinition(String name) {
        this(name, new ArrayList<Directive>(), new ArrayList<Type>());
    }

    public UnionTypeDefinition(String name, List<Directive> directives, List<Type> memberTypes) {
        this.name = name;
        this.directives = directives;
        this.memberTypes = memberTypes;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public List<Type> getMemberTypes() {
        return this.memberTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.memberTypes);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionTypeDefinition that = (UnionTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public UnionTypeDefinition deepCopy() {
        return new UnionTypeDefinition(this.name, this.deepCopy(this.directives), this.deepCopy(this.memberTypes));
    }

    public String toString() {
        return "UnionTypeDefinition{name='" + this.name + '\'' + "directives=" + this.directives + ", memberTypes=" + this.memberTypes + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitUnionTypeDefinition(this, context);
    }
}

