/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScalarTypeDefinition
extends AbstractNode<ScalarTypeDefinition>
implements TypeDefinition<ScalarTypeDefinition> {
    private final String name;
    private Description description;
    private final List<Directive> directives;

    public ScalarTypeDefinition(String name) {
        this(name, new ArrayList<Directive>());
    }

    public ScalarTypeDefinition(String name, List<Directive> directives) {
        this.name = name;
        this.directives = directives;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarTypeDefinition that = (ScalarTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public ScalarTypeDefinition deepCopy() {
        return new ScalarTypeDefinition(this.name, this.deepCopy(this.directives));
    }

    public String toString() {
        return "ScalarTypeDefinition{name='" + this.name + '\'' + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitScalarTypeDefinition(this, context);
    }
}

