/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.GraphQLException;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.util.FpKit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class NodeUtil {
    public static boolean isEqualTo(String thisStr, String thatStr) {
        return !(null == thisStr ? null != thatStr : !thisStr.equals(thatStr));
    }

    public static Map<String, Directive> directivesByName(List<Directive> directives) {
        return FpKit.getByName(directives, Directive::getName, FpKit.mergeFirst());
    }

    public static Map<String, Argument> argumentsByName(List<Argument> arguments) {
        return FpKit.getByName(arguments, Argument::getName, FpKit.mergeFirst());
    }

    public static GetOperationResult getOperation(Document document, String operationName) {
        LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
        LinkedHashMap<String, OperationDefinition> operationsByName = new LinkedHashMap<String, OperationDefinition>();
        for (Definition definition : document.getDefinitions()) {
            if (definition instanceof OperationDefinition) {
                OperationDefinition operationDefinition = (OperationDefinition)definition;
                operationsByName.put(operationDefinition.getName(), operationDefinition);
            }
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
        }
        if (operationName == null && operationsByName.size() > 1) {
            throw new GraphQLException("missing operation name");
        }
        OperationDefinition operation = operationName == null || operationName.isEmpty() ? (OperationDefinition)operationsByName.values().iterator().next() : (OperationDefinition)operationsByName.get(operationName);
        if (operation == null) {
            throw new GraphQLException("no operation found");
        }
        GetOperationResult result = new GetOperationResult();
        result.fragmentsByName = fragmentsByName;
        result.operationDefinition = operation;
        return result;
    }

    public static class GetOperationResult {
        public OperationDefinition operationDefinition;
        public Map<String, FragmentDefinition> fragmentsByName;
    }
}

