/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.util.SimpleTraverserContext;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class NodeTraverser {
    private final Map<Class<?>, Object> rootVars;
    private final Function<? super Node, ? extends List<Node>> getChildren;

    public NodeTraverser(Map<Class<?>, Object> rootVars, Function<? super Node, ? extends List<Node>> getChildren) {
        this.rootVars = rootVars;
        this.getChildren = getChildren;
    }

    public NodeTraverser() {
        this(Collections.emptyMap(), Node::getChildren);
    }

    public void depthFirst(NodeVisitor nodeVisitor, Node root) {
        this.doTraverse(nodeVisitor, Collections.singleton(root));
    }

    public void depthFirst(NodeVisitor nodeVisitor, Collection<? extends Node> roots) {
        this.doTraverse(nodeVisitor, roots);
    }

    private void doTraverse(final NodeVisitor nodeVisitor, Collection<? extends Node> roots) {
        Traverser<? super Node> nodeTraverser = Traverser.depthFirst(this.getChildren);
        nodeTraverser.rootVars(this.rootVars);
        TraverserVisitor<Node> traverserVisitor = new TraverserVisitor<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                context.setVar(LeaveOrEnter.class, LeaveOrEnter.ENTER);
                return context.thisNode().accept(context, nodeVisitor);
            }

            @Override
            public TraversalControl leave(TraverserContext<Node> context) {
                context.setVar(LeaveOrEnter.class, LeaveOrEnter.LEAVE);
                return context.thisNode().accept(context, nodeVisitor);
            }
        };
        nodeTraverser.traverse(roots, (TraverserVisitor<? super Node>)traverserVisitor);
    }

    public static <T> T oneVisitWithResult(Node node, NodeVisitor nodeVisitor) {
        SimpleTraverserContext<Node> context = new SimpleTraverserContext<Node>(node);
        node.accept(context, nodeVisitor);
        return (T)context.getResult();
    }

    public static enum LeaveOrEnter {
        LEAVE,
        ENTER;

    }
}

