/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InterfaceTypeDefinition
extends AbstractNode<InterfaceTypeDefinition>
implements TypeDefinition<InterfaceTypeDefinition> {
    private final String name;
    private Description description;
    private final List<FieldDefinition> definitions;
    private final List<Directive> directives;

    public InterfaceTypeDefinition(String name) {
        this(name, new ArrayList<FieldDefinition>(), new ArrayList<Directive>());
    }

    public InterfaceTypeDefinition(String name, List<FieldDefinition> definitions, List<Directive> directives) {
        this.name = name;
        this.definitions = definitions;
        this.directives = directives;
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return this.definitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.definitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterfaceTypeDefinition that = (InterfaceTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public InterfaceTypeDefinition deepCopy() {
        return new InterfaceTypeDefinition(this.name, this.deepCopy(this.definitions), this.deepCopy(this.directives));
    }

    public String toString() {
        return "InterfaceTypeDefinition{name='" + this.name + '\'' + ", fieldDefinitions=" + this.definitions + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInterfaceTypeDefinition(this, context);
    }
}

