/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InlineFragment
extends AbstractNode<InlineFragment>
implements Selection<InlineFragment> {
    private TypeName typeCondition;
    private List<Directive> directives;
    private SelectionSet selectionSet;

    public InlineFragment() {
        this(null, new ArrayList<Directive>(), null);
    }

    public InlineFragment(TypeName typeCondition) {
        this(typeCondition, new ArrayList<Directive>(), null);
    }

    public InlineFragment(TypeName typeCondition, SelectionSet selectionSet) {
        this(typeCondition, new ArrayList<Directive>(), selectionSet);
    }

    public InlineFragment(TypeName typeCondition, List<Directive> directives, SelectionSet selectionSet) {
        this.typeCondition = typeCondition;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public TypeName getTypeCondition() {
        return this.typeCondition;
    }

    public void setTypeCondition(TypeName typeCondition) {
        this.typeCondition = typeCondition;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.typeCondition != null) {
            result.add(this.typeCondition);
        }
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    @Override
    public InlineFragment deepCopy() {
        return new InlineFragment(this.deepCopy(this.typeCondition), this.deepCopy(this.directives), this.deepCopy(this.selectionSet));
    }

    public String toString() {
        return "InlineFragment{typeCondition='" + this.typeCondition + '\'' + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInlineFragment(this, context);
    }
}

