/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Type;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FieldDefinition
extends AbstractNode<FieldDefinition> {
    private final String name;
    private Type type;
    private Description description;
    private final List<InputValueDefinition> inputValueDefinitions;
    private final List<Directive> directives;

    public FieldDefinition(String name) {
        this(name, null, new ArrayList<InputValueDefinition>(), new ArrayList<Directive>());
    }

    public FieldDefinition(String name, Type type) {
        this(name, type, new ArrayList<InputValueDefinition>(), new ArrayList<Directive>());
    }

    public FieldDefinition(String name, Type type, List<InputValueDefinition> inputValueDefinitions, List<Directive> directives) {
        this.name = name;
        this.type = type;
        this.inputValueDefinitions = inputValueDefinitions;
        this.directives = directives;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        result.addAll(this.inputValueDefinitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinition that = (FieldDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public FieldDefinition deepCopy() {
        return new FieldDefinition(this.name, this.deepCopy(this.type), this.deepCopy(this.inputValueDefinitions), this.deepCopy(this.directives));
    }

    public String toString() {
        return "FieldDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", inputValueDefinitions=" + this.inputValueDefinitions + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitFieldDefinition(this, context);
    }
}

