/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@PublicApi
public class Field
extends AbstractNode<Field>
implements Selection<Field> {
    private String name;
    private String alias;
    private List<Argument> arguments;
    private List<Directive> directives;
    private SelectionSet selectionSet;

    public Field() {
        this(null, null, new ArrayList<Argument>(), new ArrayList<Directive>(), null);
    }

    public Field(String name) {
        this(name, null, new ArrayList<Argument>(), new ArrayList<Directive>(), null);
    }

    public Field(String name, SelectionSet selectionSet) {
        this(name, null, new ArrayList<Argument>(), new ArrayList<Directive>(), selectionSet);
    }

    public Field(String name, List<Argument> arguments) {
        this(name, null, arguments, new ArrayList<Directive>(), null);
    }

    public Field(String name, List<Argument> arguments, List<Directive> directives) {
        this(name, null, arguments, directives, null);
    }

    public Field(String name, List<Argument> arguments, SelectionSet selectionSet) {
        this(name, null, arguments, new ArrayList<Directive>(), selectionSet);
    }

    public Field(String name, String alias, List<Argument> arguments, List<Directive> directives, SelectionSet selectionSet) {
        this.name = name;
        this.alias = alias;
        this.arguments = arguments;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.arguments);
        result.addAll(this.directives);
        if (this.selectionSet != null) {
            result.add(this.selectionSet);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field that = (Field)o;
        return NodeUtil.isEqualTo(this.name, that.name) && NodeUtil.isEqualTo(this.alias, that.alias);
    }

    @Override
    public Field deepCopy() {
        return new Field(this.name, this.alias, this.deepCopy(this.arguments), this.deepCopy(this.directives), this.deepCopy(this.selectionSet));
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", arguments=" + this.arguments + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitField(this, context);
    }
}

