/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.AssertException;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AstPrinter {
    private static final Map<Class<? extends Node>, NodePrinter<? extends Node>> printers = new LinkedHashMap<Class<? extends Node>, NodePrinter<? extends Node>>();

    private static NodePrinter<Argument> argument() {
        return (out, node) -> out.printf("%s: %s", node.getName(), AstPrinter.value(node.getValue()));
    }

    private static NodePrinter<Document> document() {
        return (out, node) -> out.printf("%s\n", AstPrinter.join(node.getDefinitions(), "\n\n"));
    }

    private static NodePrinter<Directive> directive() {
        return (out, node) -> {
            String arguments = AstPrinter.wrap("(", AstPrinter.join(node.getArguments(), ", "), ")");
            out.printf("@%s%s", node.getName(), arguments);
        };
    }

    private static NodePrinter<DirectiveDefinition> directiveDefinition() {
        return (out, node) -> {
            String arguments = AstPrinter.wrap("(", AstPrinter.join(node.getInputValueDefinitions(), ", "), ")");
            String locations = AstPrinter.join(node.getDirectiveLocations(), " | ");
            out.printf("directive @%s%s on %s", node.getName(), arguments, locations);
        };
    }

    private static NodePrinter<DirectiveLocation> directiveLocation() {
        return (out, node) -> out.print(node.getName());
    }

    private static NodePrinter<EnumTypeDefinition> enumTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("enum", node.getName(), AstPrinter.directives(node.getDirectives()), AstPrinter.block(node.getEnumValueDefinitions())));
        };
    }

    private static NodePrinter<EnumValue> enumValue() {
        return (out, node) -> out.printf("%s", node.getName());
    }

    private static NodePrinter<EnumValueDefinition> enumValueDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced(node.getName(), AstPrinter.directives(node.getDirectives())));
        };
    }

    private static NodePrinter<Field> field() {
        return (out, node) -> {
            String alias = AstPrinter.wrap("", node.getAlias(), ": ");
            String name = node.getName();
            String arguments = AstPrinter.wrap("(", AstPrinter.join(node.getArguments(), ", "), ")");
            String directives = AstPrinter.directives(node.getDirectives());
            String selectionSet = AstPrinter.node(node.getSelectionSet());
            out.printf("%s", AstPrinter.spaced(alias + name + arguments, directives, selectionSet));
        };
    }

    private static NodePrinter<FieldDefinition> fieldDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            if (AstPrinter.hasComments(node.getInputValueDefinitions())) {
                String args = AstPrinter.join(node.getInputValueDefinitions(), "\n");
                out.printf("%s", node.getName() + AstPrinter.wrap("(\n", args, "\n)") + ": " + AstPrinter.spaced(AstPrinter.type(node.getType()), AstPrinter.directives(node.getDirectives())));
            } else {
                String args = AstPrinter.join(node.getInputValueDefinitions(), ", ");
                out.printf("%s", node.getName() + AstPrinter.wrap("(", args, ")") + ": " + AstPrinter.spaced(AstPrinter.type(node.getType()), AstPrinter.directives(node.getDirectives())));
            }
        };
    }

    private static boolean hasComments(List<? extends Node> nodes) {
        return nodes.stream().filter(it -> it.getComments().size() > 0).count() > 0L;
    }

    private static NodePrinter<FragmentDefinition> fragmentDefinition() {
        return (out, node) -> {
            String name = node.getName();
            String typeCondition = AstPrinter.type(node.getTypeCondition());
            String directives = AstPrinter.directives(node.getDirectives());
            String selectionSet = AstPrinter.node(node.getSelectionSet());
            out.printf("fragment %s on %s ", name, typeCondition);
            out.printf("%s", directives + selectionSet);
        };
    }

    private static NodePrinter<FragmentSpread> fragmentSpread() {
        return (out, node) -> {
            String name = node.getName();
            String directives = AstPrinter.directives(node.getDirectives());
            out.printf("...%s%s", name, directives);
        };
    }

    private static NodePrinter<InlineFragment> inlineFragment() {
        return (out, node) -> {
            String typeCondition = AstPrinter.wrap("on ", AstPrinter.type(node.getTypeCondition()), "");
            String directives = AstPrinter.directives(node.getDirectives());
            String selectionSet = AstPrinter.node(node.getSelectionSet());
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("...", typeCondition, directives, selectionSet));
        };
    }

    private static NodePrinter<InputObjectTypeDefinition> inputObjectTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("input", node.getName(), AstPrinter.directives(node.getDirectives()), AstPrinter.block(node.getInputValueDefinitions())));
        };
    }

    private static NodePrinter<InputValueDefinition> inputValueDefinition() {
        return (out, node) -> {
            Value defaultValue = node.getDefaultValue();
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced(node.getName() + ": " + AstPrinter.type(node.getType()), AstPrinter.wrap("= ", defaultValue, ""), AstPrinter.directives(node.getDirectives())));
        };
    }

    private static NodePrinter<InterfaceTypeDefinition> interfaceTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("interface", node.getName(), AstPrinter.directives(node.getDirectives()), AstPrinter.block(node.getFieldDefinitions())));
        };
    }

    private static NodePrinter<ObjectField> objectField() {
        return (out, node) -> out.printf("%s : %s", node.getName(), AstPrinter.value(node.getValue()));
    }

    private static NodePrinter<OperationDefinition> operationDefinition() {
        return (out, node) -> {
            String op = node.getOperation().toString().toLowerCase();
            String name = node.getName();
            String varDefinitions = AstPrinter.wrap("(", AstPrinter.join(AstPrinter.nvl(node.getVariableDefinitions()), ", "), ")");
            String directives = AstPrinter.directives(node.getDirectives());
            String selectionSet = AstPrinter.node(node.getSelectionSet());
            if (AstPrinter.isEmpty(name) && AstPrinter.isEmpty(directives) && AstPrinter.isEmpty(varDefinitions) && op.equals("QUERY")) {
                out.printf("%s", selectionSet);
            } else {
                out.printf("%s", AstPrinter.spaced(op, AstPrinter.smooshed(name, varDefinitions), directives, selectionSet));
            }
        };
    }

    private static NodePrinter<OperationTypeDefinition> operationTypeDefinition() {
        return (out, node) -> out.printf("%s: %s", node.getName(), AstPrinter.type(node.getType()));
    }

    private static NodePrinter<ObjectTypeDefinition> objectTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("type", node.getName(), AstPrinter.wrap("implements ", AstPrinter.join(node.getImplements(), " & "), ""), AstPrinter.directives(node.getDirectives()), AstPrinter.block(node.getFieldDefinitions())));
        };
    }

    private static NodePrinter<SelectionSet> selectionSet() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.block(node.getSelections()));
        };
    }

    private static NodePrinter<ScalarTypeDefinition> scalarTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("scalar", node.getName(), AstPrinter.directives(node.getDirectives())));
        };
    }

    private static NodePrinter<SchemaDefinition> schemaDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("schema", AstPrinter.directives(node.getDirectives()), AstPrinter.block(node.getOperationTypeDefinitions())));
        };
    }

    private static NodePrinter<Type> type() {
        return (out, node) -> out.print(AstPrinter.type(node));
    }

    private static String type(Type type) {
        if (type instanceof NonNullType) {
            NonNullType inner = (NonNullType)type;
            return AstPrinter.wrap("", AstPrinter.type(inner.getType()), "!");
        }
        if (type instanceof ListType) {
            ListType inner = (ListType)type;
            return AstPrinter.wrap("[", AstPrinter.type(inner.getType()), "]");
        }
        TypeName inner = (TypeName)type;
        return inner.getName();
    }

    private static NodePrinter<ObjectTypeExtensionDefinition> objectTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", AstPrinter.node(node, ObjectTypeDefinition.class));
    }

    private static NodePrinter<EnumTypeExtensionDefinition> enumTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", AstPrinter.node(node, EnumTypeDefinition.class));
    }

    private static NodePrinter<InterfaceTypeDefinition> interfaceTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", AstPrinter.node(node, InterfaceTypeDefinition.class));
    }

    private static NodePrinter<UnionTypeExtensionDefinition> unionTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", AstPrinter.node(node, UnionTypeDefinition.class));
    }

    private static NodePrinter<ScalarTypeExtensionDefinition> scalarTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", AstPrinter.node(node, ScalarTypeDefinition.class));
    }

    private static NodePrinter<InputObjectTypeExtensionDefinition> inputObjectTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", AstPrinter.node(node, InputObjectTypeDefinition.class));
    }

    private static NodePrinter<UnionTypeDefinition> unionTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", AstPrinter.comments(node));
            out.printf("%s", AstPrinter.spaced("union", node.getName(), AstPrinter.directives(node.getDirectives()), "= " + AstPrinter.join(node.getMemberTypes(), " | ")));
        };
    }

    private static NodePrinter<VariableDefinition> variableDefinition() {
        return (out, node) -> out.printf("$%s: %s%s", node.getName(), AstPrinter.type(node.getType()), AstPrinter.wrap(" = ", node.getDefaultValue(), ""));
    }

    private static NodePrinter<VariableReference> variableReference() {
        return (out, node) -> out.printf("$%s", node.getName());
    }

    private static String node(Node node) {
        return AstPrinter.node(node, null);
    }

    private static String node(Node node, Class startClass) {
        if (startClass != null) {
            Assert.assertTrue(startClass.isInstance(node), "The starting class must be in the inherit tree", new Object[0]);
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        NodePrinter<Node> printer = AstPrinter._findPrinter(node, startClass);
        printer.print(out, node);
        return sw.toString();
    }

    private static <T extends Node> NodePrinter<T> _findPrinter(Node node) {
        return AstPrinter._findPrinter(node, null);
    }

    private static <T extends Node> NodePrinter<T> _findPrinter(Node node, Class startClass) {
        Class<?> clazz;
        if (node == null) {
            return (out, type) -> {};
        }
        Class<?> clazz2 = clazz = startClass != null ? startClass : node.getClass();
        while (clazz != Object.class) {
            NodePrinter<? extends Node> nodePrinter = printers.get(clazz);
            if (nodePrinter != null) {
                return nodePrinter;
            }
            clazz = clazz.getSuperclass();
        }
        throw new AssertException(String.format("We have a missing printer implementation for %s : report a bug!", clazz));
    }

    private static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static <T> List<T> nvl(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private static NodePrinter<Value> value() {
        return (out, node) -> out.print(AstPrinter.value(node));
    }

    private static String value(Value value) {
        if (value instanceof IntValue) {
            return String.valueOf(((IntValue)value).getValue());
        }
        if (value instanceof FloatValue) {
            return String.valueOf(((FloatValue)value).getValue());
        }
        if (value instanceof StringValue) {
            return AstPrinter.wrap("\"", String.valueOf(((StringValue)value).getValue()), "\"");
        }
        if (value instanceof EnumValue) {
            return String.valueOf(((EnumValue)value).getName());
        }
        if (value instanceof BooleanValue) {
            return String.valueOf(((BooleanValue)value).isValue());
        }
        if (value instanceof NullValue) {
            return "null";
        }
        if (value instanceof ArrayValue) {
            return "[" + AstPrinter.join(((ArrayValue)value).getValues(), ", ") + "]";
        }
        if (value instanceof ObjectValue) {
            return "{" + AstPrinter.join(((ObjectValue)value).getObjectFields(), ", ") + "}";
        }
        if (value instanceof VariableReference) {
            return "$" + ((VariableReference)value).getName();
        }
        return "";
    }

    private static String comments(Node<?> node) {
        List<Comment> comments = AstPrinter.nvl(node.getComments());
        if (AstPrinter.isEmpty(comments)) {
            return "";
        }
        String s = comments.stream().map(c -> "#" + c.getContent()).collect(Collectors.joining("\n", "", "\n"));
        return s;
    }

    private static String directives(List<Directive> directives) {
        return AstPrinter.join(AstPrinter.nvl(directives), " ");
    }

    private static <T extends Node> String join(List<T> nodes, String delim) {
        return AstPrinter.join(nodes, delim, "", "");
    }

    private static <T extends Node> String join(List<T> nodes, String delim, String prefix, String suffix) {
        String s = AstPrinter.nvl(nodes).stream().map(AstPrinter::node).collect(Collectors.joining(delim, prefix, suffix));
        return s;
    }

    private static String spaced(String ... args) {
        return AstPrinter.join(" ", args);
    }

    private static String smooshed(String ... args) {
        return AstPrinter.join("", args);
    }

    private static String join(String delim, String ... args) {
        String s = Arrays.stream(args).filter(arg -> !AstPrinter.isEmpty(arg)).collect(Collectors.joining(delim));
        return s;
    }

    static String wrap(String start, String maybeString, String end) {
        if (AstPrinter.isEmpty(maybeString)) {
            if (start.equals("\"") && end.equals("\"")) {
                return "\"\"";
            }
            return "";
        }
        return start + maybeString + (!AstPrinter.isEmpty(end) ? end : "");
    }

    private static <T extends Node> String block(List<T> nodes) {
        if (AstPrinter.isEmpty(nodes)) {
            return "{}";
        }
        return AstPrinter.indent("{\n" + AstPrinter.join(nodes, "\n")) + "\n}";
    }

    private static String indent(String maybeString) {
        if (AstPrinter.isEmpty(maybeString)) {
            return "";
        }
        maybeString = maybeString.replaceAll("\\n", "\n  ");
        return maybeString;
    }

    static String wrap(String start, Node maybeNode, String end) {
        if (maybeNode == null) {
            return "";
        }
        return start + AstPrinter.node(maybeNode) + (AstPrinter.isEmpty(end) ? "" : end);
    }

    public static String printAst(Node node) {
        StringWriter sw = new StringWriter();
        AstPrinter.printAst(sw, node);
        return sw.toString();
    }

    public static String printAstCompact(Node node) {
        StringWriter sw = new StringWriter();
        AstPrinter.printAst(sw, node);
        return sw.toString().replaceAll("\\s+", " ").trim();
    }

    public static void printAst(Writer writer, Node node) {
        NodePrinter<Node> printer = AstPrinter._findPrinter(node);
        printer.print(new PrintWriter(writer), node);
    }

    static {
        printers.put(Argument.class, AstPrinter.argument());
        printers.put(ArrayValue.class, AstPrinter.value());
        printers.put(BooleanValue.class, AstPrinter.value());
        printers.put(NullValue.class, AstPrinter.value());
        printers.put(Directive.class, AstPrinter.directive());
        printers.put(DirectiveDefinition.class, AstPrinter.directiveDefinition());
        printers.put(DirectiveLocation.class, AstPrinter.directiveLocation());
        printers.put(Document.class, AstPrinter.document());
        printers.put(EnumTypeDefinition.class, AstPrinter.enumTypeDefinition());
        printers.put(EnumTypeExtensionDefinition.class, AstPrinter.enumTypeExtensionDefinition());
        printers.put(EnumValue.class, AstPrinter.enumValue());
        printers.put(EnumValueDefinition.class, AstPrinter.enumValueDefinition());
        printers.put(Field.class, AstPrinter.field());
        printers.put(FieldDefinition.class, AstPrinter.fieldDefinition());
        printers.put(FloatValue.class, AstPrinter.value());
        printers.put(FragmentDefinition.class, AstPrinter.fragmentDefinition());
        printers.put(FragmentSpread.class, AstPrinter.fragmentSpread());
        printers.put(InlineFragment.class, AstPrinter.inlineFragment());
        printers.put(InputObjectTypeDefinition.class, AstPrinter.inputObjectTypeDefinition());
        printers.put(InputObjectTypeExtensionDefinition.class, AstPrinter.inputObjectTypeExtensionDefinition());
        printers.put(InputValueDefinition.class, AstPrinter.inputValueDefinition());
        printers.put(InterfaceTypeDefinition.class, AstPrinter.interfaceTypeDefinition());
        printers.put(InterfaceTypeExtensionDefinition.class, AstPrinter.interfaceTypeExtensionDefinition());
        printers.put(IntValue.class, AstPrinter.value());
        printers.put(ListType.class, AstPrinter.type());
        printers.put(NonNullType.class, AstPrinter.type());
        printers.put(ObjectField.class, AstPrinter.objectField());
        printers.put(ObjectTypeDefinition.class, AstPrinter.objectTypeDefinition());
        printers.put(ObjectTypeExtensionDefinition.class, AstPrinter.objectTypeExtensionDefinition());
        printers.put(ObjectValue.class, AstPrinter.value());
        printers.put(OperationDefinition.class, AstPrinter.operationDefinition());
        printers.put(OperationTypeDefinition.class, AstPrinter.operationTypeDefinition());
        printers.put(ScalarTypeDefinition.class, AstPrinter.scalarTypeDefinition());
        printers.put(ScalarTypeExtensionDefinition.class, AstPrinter.scalarTypeExtensionDefinition());
        printers.put(SchemaDefinition.class, AstPrinter.schemaDefinition());
        printers.put(SelectionSet.class, AstPrinter.selectionSet());
        printers.put(StringValue.class, AstPrinter.value());
        printers.put(TypeName.class, AstPrinter.type());
        printers.put(UnionTypeDefinition.class, AstPrinter.unionTypeDefinition());
        printers.put(UnionTypeExtensionDefinition.class, AstPrinter.unionTypeExtensionDefinition());
        printers.put(VariableDefinition.class, AstPrinter.variableDefinition());
        printers.put(VariableReference.class, AstPrinter.variableReference());
    }

    private static interface NodePrinter<T extends Node> {
        public void print(PrintWriter var1, T var2);
    }
}

