/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.language.Comment;
import graphql.language.Node;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractNode<T extends Node>
implements Node<T> {
    private SourceLocation sourceLocation;
    private List<Comment> comments = Collections.emptyList();

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        Assert.assertNotNull(comments, "You must provide non null comments", new Object[0]);
        this.comments = comments;
    }

    protected <V extends Node> V deepCopy(V nullableObj) {
        if (nullableObj == null) {
            return null;
        }
        return (V)nullableObj.deepCopy();
    }

    protected <V extends Node> List<V> deepCopy(List<? extends Node> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(Node::deepCopy).map(node -> node).collect(Collectors.toList());
    }
}

