/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.reactive.NonBlockingMutexExecutor;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class SingleSubscriberPublisher<T>
implements Publisher<T> {
    private final Deque<T> dataQ = new ConcurrentLinkedDeque<T>();
    private final NonBlockingMutexExecutor mutex = new NonBlockingMutexExecutor();
    private final OnSubscriptionCallback subscriptionCallback;
    private Subscriber<? super T> subscriber;
    private Throwable pendingThrowable = null;
    private boolean running = true;
    private boolean noMoreData = false;
    private long demand = 0L;

    public SingleSubscriberPublisher() {
        this(() -> {});
    }

    public SingleSubscriberPublisher(OnSubscriptionCallback subscriptionCallback) {
        this.subscriptionCallback = Assert.assertNotNull(subscriptionCallback);
    }

    public void offer(T data) {
        this.mutex.execute(() -> this.dataQ.offer(data));
    }

    public void noMoreData() {
        this.mutex.execute(() -> {
            this.noMoreData = true;
            this.maybeReadInMutex();
        });
    }

    public void offerError(Throwable t) {
        this.mutex.execute(() -> {
            this.pendingThrowable = t;
            this.maybeReadInMutex();
        });
    }

    private void handleError(Throwable t) {
        if (this.running) {
            this.running = false;
            this.subscriber.onError(t);
            this.subscriber = null;
        }
    }

    private void handleOnComplete() {
        if (this.running) {
            this.running = false;
            this.subscriber.onComplete();
            this.subscriber = null;
        }
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Assert.assertNotNull(subscriber, "Subscriber passed to subscribe must not be null", new Object[0]);
        this.mutex.execute(() -> {
            if (this.subscriber == null) {
                this.subscriber = subscriber;
                this.subscriptionCallback.onSubscription();
                subscriber.onSubscribe((Subscription)new SimpleSubscription());
                if (this.pendingThrowable != null) {
                    this.handleError(this.pendingThrowable);
                }
            } else if (this.subscriber.equals((Object)subscriber)) {
                this.handleError(new IllegalStateException("Attempted to subscribe this Subscriber more than once for the same Publisher"));
            } else {
                subscriber.onSubscribe(new Subscription(){

                    public void request(long n) {
                    }

                    public void cancel() {
                    }
                });
                subscriber.onError((Throwable)new IllegalStateException("This publisher only supports one subscriber"));
            }
        });
    }

    private void maybeReadInMutex() {
        while (this.running && this.demand > 0L) {
            if (this.pendingThrowable != null) {
                this.handleError(this.pendingThrowable);
                return;
            }
            if (this.dataQ.isEmpty() && this.noMoreData) {
                this.handleOnComplete();
                return;
            }
            if (!this.dataQ.isEmpty()) {
                T data = this.dataQ.removeFirst();
                this.subscriber.onNext(data);
                --this.demand;
                continue;
            }
            return;
        }
    }

    public static interface OnSubscriptionCallback {
        public void onSubscription();
    }

    private class SimpleSubscription
    implements Subscription {
        private SimpleSubscription() {
        }

        public void request(long n) {
            SingleSubscriberPublisher.this.mutex.execute(() -> {
                if (SingleSubscriberPublisher.this.running) {
                    if (n <= 0L) {
                        SingleSubscriberPublisher.this.handleError(new IllegalArgumentException("Reactive streams 3.9 spec violation: non-positive subscription request"));
                    } else {
                        long old = SingleSubscriberPublisher.this.demand;
                        if (old < Long.MAX_VALUE) {
                            SingleSubscriberPublisher.this.demand = old + n < 0L ? Long.MAX_VALUE : old + n;
                        }
                        if (old == 0L) {
                            SingleSubscriberPublisher.this.maybeReadInMutex();
                        }
                    }
                }
            });
        }

        public void cancel() {
            SingleSubscriberPublisher.this.mutex.execute(() -> {
                if (SingleSubscriberPublisher.this.running) {
                    SingleSubscriberPublisher.this.subscriber = null;
                    SingleSubscriberPublisher.this.running = false;
                }
            });
        }
    }
}

