/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.defer;

import graphql.Directives;
import graphql.ExecutionResult;
import graphql.Internal;
import graphql.execution.defer.DeferredCall;
import graphql.execution.reactive.SingleSubscriberPublisher;
import graphql.language.Field;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;

@Internal
public class DeferSupport {
    private final AtomicBoolean deferDetected = new AtomicBoolean(false);
    private final Deque<DeferredCall> deferredCalls = new ConcurrentLinkedDeque<DeferredCall>();
    private final SingleSubscriberPublisher<ExecutionResult> publisher = new SingleSubscriberPublisher();

    public boolean checkForDeferDirective(List<Field> currentField) {
        for (Field field : currentField) {
            if (field.getDirective(Directives.DeferDirective.getName()) == null) continue;
            return true;
        }
        return false;
    }

    private void drainDeferredCalls() {
        if (this.deferredCalls.isEmpty()) {
            this.publisher.noMoreData();
            return;
        }
        DeferredCall deferredCall = this.deferredCalls.pop();
        CompletableFuture<ExecutionResult> future = deferredCall.invoke();
        future.whenComplete((executionResult, exception) -> {
            if (exception != null) {
                this.publisher.offerError((Throwable)exception);
                return;
            }
            this.publisher.offer((ExecutionResult)executionResult);
            this.drainDeferredCalls();
        });
    }

    public void enqueue(DeferredCall deferredCall) {
        this.deferDetected.set(true);
        this.deferredCalls.offer(deferredCall);
    }

    public boolean isDeferDetected() {
        return this.deferDetected.get();
    }

    public Publisher<ExecutionResult> startDeferredCalls() {
        this.drainDeferredCalls();
        return this.publisher;
    }
}

