/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.Internal;
import graphql.analysis.ChildrenOfSelectionProvider;
import graphql.analysis.FieldVisitor;
import graphql.analysis.QueryReducer;
import graphql.analysis.QueryTraversalContext;
import graphql.analysis.QueryVisitorEnvironment;
import graphql.execution.ConditionalNodes;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class QueryTraversal {
    private final OperationDefinition operationDefinition;
    private final GraphQLSchema schema;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private final Map<String, Object> variables;
    private final ConditionalNodes conditionalNodes = new ConditionalNodes();
    private final ValuesResolver valuesResolver = new ValuesResolver();
    private final SchemaUtil schemaUtil = new SchemaUtil();
    private final ChildrenOfSelectionProvider childrenOfSelectionProvider;

    public QueryTraversal(GraphQLSchema schema, Document document, String operation, Map<String, Object> variables) {
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operation);
        this.operationDefinition = getOperationResult.operationDefinition;
        this.fragmentsByName = getOperationResult.fragmentsByName;
        this.childrenOfSelectionProvider = new ChildrenOfSelectionProvider(this.fragmentsByName);
        this.schema = schema;
        this.variables = variables;
    }

    public void visitPostOrder(FieldVisitor visitor) {
        this.visitImpl(visitor, this.operationDefinition.getSelectionSet(), this.getRootType(), false);
    }

    public void visitPreOrder(FieldVisitor visitor) {
        this.visitImpl(visitor, this.operationDefinition.getSelectionSet(), this.getRootType(), true);
    }

    private GraphQLObjectType getRootType() {
        switch (this.operationDefinition.getOperation()) {
            case MUTATION: {
                return Assert.assertNotNull(this.schema.getMutationType());
            }
            case QUERY: {
                return Assert.assertNotNull(this.schema.getQueryType());
            }
            case SUBSCRIPTION: {
                return Assert.assertNotNull(this.schema.getSubscriptionType());
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen();
    }

    public <T> T reducePostOrder(QueryReducer<T> queryReducer, T initialValue) {
        Object[] acc = new Object[]{initialValue};
        this.visitPostOrder(env -> {
            acc[0] = queryReducer.reduceField(env, acc[0]);
        });
        return (T)acc[0];
    }

    public <T> T reducePreOrder(QueryReducer<T> queryReducer, T initialValue) {
        Object[] acc = new Object[]{initialValue};
        this.visitPreOrder(env -> {
            acc[0] = queryReducer.reduceField(env, acc[0]);
        });
        return (T)acc[0];
    }

    private List<Node> childrenOf(Node selection) {
        return this.childrenOfSelectionProvider.getSelections((Selection)selection);
    }

    private void visitImpl(FieldVisitor visitFieldCallback, SelectionSet selectionSet, GraphQLCompositeType type, boolean preOrder) {
        LinkedHashMap rootVars = new LinkedHashMap();
        rootVars.put(QueryTraversalContext.class, new QueryTraversalContext(type, null));
        FieldVisitor noOp = notUsed -> {};
        FieldVisitor preOrderCallback = preOrder ? visitFieldCallback : noOp;
        FieldVisitor postOrderCallback = !preOrder ? visitFieldCallback : noOp;
        NodeTraverser nodeTraverser = new NodeTraverser(rootVars, this::childrenOf);
        nodeTraverser.depthFirst((NodeVisitor)new NodeVisitorImpl(preOrderCallback, postOrderCallback), selectionSet.getSelections());
    }

    private class NodeVisitorImpl
    extends NodeVisitorStub {
        final FieldVisitor preOrderCallback;
        final FieldVisitor postOrderCallback;

        NodeVisitorImpl(FieldVisitor preOrderCallback, FieldVisitor postOrderCallback) {
            this.preOrderCallback = preOrderCallback;
            this.postOrderCallback = postOrderCallback;
        }

        @Override
        public TraversalControl visitInlineFragment(InlineFragment inlineFragment, TraverserContext<Node> context) {
            GraphQLCompositeType fragmentCondition;
            if (context.getVar(NodeTraverser.LeaveOrEnter.class) == NodeTraverser.LeaveOrEnter.LEAVE) {
                return TraversalControl.CONTINUE;
            }
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, inlineFragment.getDirectives())) {
                return TraversalControl.ABORT;
            }
            QueryTraversalContext parentEnv = context.getParentContext().getVar(QueryTraversalContext.class);
            if (inlineFragment.getTypeCondition() != null) {
                TypeName typeCondition = inlineFragment.getTypeCondition();
                fragmentCondition = (GraphQLCompositeType)QueryTraversal.this.schema.getType(typeCondition.getName());
            } else {
                fragmentCondition = parentEnv.getType();
            }
            context.setVar(QueryTraversalContext.class, new QueryTraversalContext(fragmentCondition, parentEnv.getEnvironment()));
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl visitFragmentSpread(FragmentSpread fragmentSpread, TraverserContext<Node> context) {
            if (context.getVar(NodeTraverser.LeaveOrEnter.class) == NodeTraverser.LeaveOrEnter.LEAVE) {
                return TraversalControl.CONTINUE;
            }
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, fragmentSpread.getDirectives())) {
                return TraversalControl.ABORT;
            }
            FragmentDefinition fragmentDefinition = (FragmentDefinition)QueryTraversal.this.fragmentsByName.get(fragmentSpread.getName());
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, fragmentDefinition.getDirectives())) {
                return TraversalControl.ABORT;
            }
            QueryTraversalContext parentEnv = context.getParentContext().getVar(QueryTraversalContext.class);
            GraphQLCompositeType typeCondition = (GraphQLCompositeType)QueryTraversal.this.schema.getType(fragmentDefinition.getTypeCondition().getName());
            context.setVar(QueryTraversalContext.class, new QueryTraversalContext(typeCondition, parentEnv.getEnvironment()));
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl visitField(Field field, TraverserContext<Node> context) {
            QueryTraversalContext parentEnv = context.getParentContext().getVar(QueryTraversalContext.class);
            GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(QueryTraversal.this.schema, parentEnv.getType(), field.getName());
            Map<String, Object> argumentValues = QueryTraversal.this.valuesResolver.getArgumentValues(QueryTraversal.this.schema.getFieldVisibility(), fieldDefinition.getArguments(), field.getArguments(), QueryTraversal.this.variables);
            QueryVisitorEnvironment environment = new QueryVisitorEnvironment(field, fieldDefinition, parentEnv.getType(), parentEnv.getEnvironment(), argumentValues);
            NodeTraverser.LeaveOrEnter leaveOrEnter = context.getVar(NodeTraverser.LeaveOrEnter.class);
            if (leaveOrEnter == NodeTraverser.LeaveOrEnter.LEAVE) {
                this.postOrderCallback.visitField(environment);
                return TraversalControl.CONTINUE;
            }
            if (!QueryTraversal.this.conditionalNodes.shouldInclude(QueryTraversal.this.variables, field.getDirectives())) {
                return TraversalControl.ABORT;
            }
            this.preOrderCallback.visitField(environment);
            GraphQLUnmodifiedType unmodifiedType = QueryTraversal.this.schemaUtil.getUnmodifiedType(fieldDefinition.getType());
            QueryTraversalContext fieldEnv = unmodifiedType instanceof GraphQLCompositeType ? new QueryTraversalContext((GraphQLCompositeType)((Object)unmodifiedType), environment) : new QueryTraversalContext(null, environment);
            context.setVar(QueryTraversalContext.class, fieldEnv);
            return TraversalControl.CONTINUE;
        }
    }
}

