/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.Internal;
import graphql.InvalidSyntaxError;
import graphql.PublicApi;
import graphql.execution.AbortExecutionException;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.Execution;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class GraphQL {
    public static final String DEFERRED_RESULTS = "deferredResults";
    private static final Logger log = LoggerFactory.getLogger(GraphQL.class);
    private static final ExecutionIdProvider DEFAULT_EXECUTION_ID_PROVIDER = (query, operationName, context) -> ExecutionId.generate();
    private final GraphQLSchema graphQLSchema;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final ExecutionIdProvider idProvider;
    private final Instrumentation instrumentation;
    private final PreparsedDocumentProvider preparsedDocumentProvider;

    @Internal
    public GraphQL(GraphQLSchema graphQLSchema) {
        this(graphQLSchema, null, null);
    }

    @Internal
    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy) {
        this(graphQLSchema, queryStrategy, null);
    }

    @Internal
    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy) {
        this(graphQLSchema, queryStrategy, mutationStrategy, null, DEFAULT_EXECUTION_ID_PROVIDER, SimpleInstrumentation.INSTANCE, NoOpPreparsedDocumentProvider.INSTANCE);
    }

    @Internal
    public GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy) {
        this(graphQLSchema, queryStrategy, mutationStrategy, subscriptionStrategy, DEFAULT_EXECUTION_ID_PROVIDER, SimpleInstrumentation.INSTANCE, NoOpPreparsedDocumentProvider.INSTANCE);
    }

    private GraphQL(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, ExecutionIdProvider idProvider, Instrumentation instrumentation, PreparsedDocumentProvider preparsedDocumentProvider) {
        this.graphQLSchema = Assert.assertNotNull(graphQLSchema, "queryStrategy must be non null", new Object[0]);
        this.queryStrategy = queryStrategy != null ? queryStrategy : new AsyncExecutionStrategy();
        this.mutationStrategy = mutationStrategy != null ? mutationStrategy : new AsyncSerialExecutionStrategy();
        this.subscriptionStrategy = subscriptionStrategy != null ? subscriptionStrategy : new SubscriptionExecutionStrategy();
        this.idProvider = Assert.assertNotNull(idProvider, "idProvider must be non null", new Object[0]);
        this.instrumentation = instrumentation;
        this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, "preparsedDocumentProvider must be non null", new Object[0]);
    }

    public static Builder newGraphQL(GraphQLSchema graphQLSchema) {
        return new Builder(graphQLSchema);
    }

    public GraphQL transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this.graphQLSchema);
        builder.queryExecutionStrategy(GraphQL.nvl(this.queryStrategy, builder.queryExecutionStrategy)).mutationExecutionStrategy(GraphQL.nvl(this.mutationStrategy, builder.mutationExecutionStrategy)).subscriptionExecutionStrategy(GraphQL.nvl(this.subscriptionStrategy, builder.subscriptionExecutionStrategy)).executionIdProvider(GraphQL.nvl(this.idProvider, builder.idProvider)).instrumentation(GraphQL.nvl(this.instrumentation, builder.instrumentation)).preparsedDocumentProvider(GraphQL.nvl(this.preparsedDocumentProvider, builder.preparsedDocumentProvider));
        builderConsumer.accept(builder);
        return builder.build();
    }

    private static <T> T nvl(T obj, T elseObj) {
        return obj == null ? elseObj : obj;
    }

    public ExecutionResult execute(String query) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, Object context) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).context(context).root(context).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, String operationName, Object context) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).context(context).root(context).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, Object context, Map<String, Object> variables) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).context(context).root(context).variables(variables).build();
        return this.execute(executionInput);
    }

    @Deprecated
    public ExecutionResult execute(String query, String operationName, Object context, Map<String, Object> variables) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).operationName(operationName).context(context).root(context).variables(variables).build();
        return this.execute(executionInput);
    }

    public ExecutionResult execute(ExecutionInput.Builder executionInputBuilder) {
        return this.execute(executionInputBuilder.build());
    }

    public ExecutionResult execute(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.execute(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public ExecutionResult execute(ExecutionInput executionInput) {
        try {
            return this.executeAsync(executionInput).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput.Builder executionInputBuilder) {
        return this.executeAsync(executionInputBuilder.build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(UnaryOperator<ExecutionInput.Builder> builderFunction) {
        return this.executeAsync(((ExecutionInput.Builder)builderFunction.apply(ExecutionInput.newExecutionInput())).build());
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        try {
            log.debug("Executing request. operation name: '{}'. query: '{}'. variables '{}'", new Object[]{executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables()});
            InstrumentationState instrumentationState = this.instrumentation.createState();
            InstrumentationExecutionParameters inputInstrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            executionInput = this.instrumentation.instrumentExecutionInput(executionInput, inputInstrumentationParameters);
            InstrumentationExecutionParameters instrumentationParameters = new InstrumentationExecutionParameters(executionInput, this.graphQLSchema, instrumentationState);
            InstrumentationContext<ExecutionResult> executionInstrumentation = this.instrumentation.beginExecution(instrumentationParameters);
            GraphQLSchema graphQLSchema = this.instrumentation.instrumentSchema(this.graphQLSchema, instrumentationParameters);
            CompletionStage<ExecutionResult> executionResult = this.parseValidateAndExecute(executionInput, graphQLSchema, instrumentationState);
            executionResult = ((CompletableFuture)executionResult).whenComplete(executionInstrumentation::onCompleted);
            executionResult = ((CompletableFuture)executionResult).thenCompose(result -> this.instrumentation.instrumentExecutionResult((ExecutionResult)result, instrumentationParameters));
            return executionResult;
        }
        catch (AbortExecutionException abortException) {
            ExecutionResultImpl executionResult = new ExecutionResultImpl(abortException);
            if (!abortException.getUnderlyingErrors().isEmpty()) {
                executionResult = new ExecutionResultImpl(abortException.getUnderlyingErrors());
            }
            return CompletableFuture.completedFuture(executionResult);
        }
    }

    private CompletableFuture<ExecutionResult> parseValidateAndExecute(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        AtomicReference<ExecutionInput> executionInputRef = new AtomicReference<ExecutionInput>(executionInput);
        PreparsedDocumentEntry preparsedDoc = this.preparsedDocumentProvider.get(executionInput.getQuery(), transformedQuery -> {
            executionInputRef.set(executionInput.transform((ExecutionInput.Builder bldr) -> bldr.query((String)transformedQuery)));
            return this.parseAndValidate((ExecutionInput)executionInputRef.get(), graphQLSchema, instrumentationState);
        });
        if (preparsedDoc.hasErrors()) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(preparsedDoc.getErrors()));
        }
        return this.execute(executionInputRef.get(), preparsedDoc.getDocument(), graphQLSchema, instrumentationState);
    }

    private PreparsedDocumentEntry parseAndValidate(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        log.debug("Parsing query: '{}'...", (Object)executionInput.getQuery());
        ParseResult parseResult = this.parse(executionInput, graphQLSchema, instrumentationState);
        if (parseResult.isFailure()) {
            log.warn("Query failed to parse : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(InvalidSyntaxError.toInvalidSyntaxError(parseResult.getException()));
        }
        Document document = parseResult.getDocument();
        log.debug("Validating query: '{}'", (Object)executionInput.getQuery());
        List<ValidationError> errors = this.validate(executionInput, document, graphQLSchema, instrumentationState);
        if (!errors.isEmpty()) {
            log.warn("Query failed to validate : '{}'", (Object)executionInput.getQuery());
            return new PreparsedDocumentEntry(errors);
        }
        return new PreparsedDocumentEntry(document);
    }

    private ParseResult parse(ExecutionInput executionInput, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        Document document;
        InstrumentationContext<Document> parseInstrumentation = this.instrumentation.beginParse(new InstrumentationExecutionParameters(executionInput, graphQLSchema, instrumentationState));
        Parser parser = new Parser();
        try {
            document = parser.parseDocument(executionInput.getQuery());
        }
        catch (ParseCancellationException e) {
            parseInstrumentation.onCompleted(null, e);
            return ParseResult.ofError((Exception)((Object)e));
        }
        parseInstrumentation.onCompleted(document, null);
        return ParseResult.of(document);
    }

    private List<ValidationError> validate(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        InstrumentationContext<List<ValidationError>> validationCtx = this.instrumentation.beginValidation(new InstrumentationValidationParameters(executionInput, document, graphQLSchema, instrumentationState));
        Validator validator = new Validator();
        List<ValidationError> validationErrors = validator.validateDocument(graphQLSchema, document);
        validationCtx.onCompleted(validationErrors, null);
        return validationErrors;
    }

    private CompletableFuture<ExecutionResult> execute(ExecutionInput executionInput, Document document, GraphQLSchema graphQLSchema, InstrumentationState instrumentationState) {
        String query = executionInput.getQuery();
        String operationName = executionInput.getOperationName();
        Object context = executionInput.getContext();
        Execution execution = new Execution(this.queryStrategy, this.mutationStrategy, this.subscriptionStrategy, this.instrumentation);
        ExecutionId executionId = this.idProvider.provide(query, operationName, context);
        log.debug("Executing '{}'. operation name: '{}'. query: '{}'. variables '{}'", new Object[]{executionId, executionInput.getOperationName(), executionInput.getQuery(), executionInput.getVariables()});
        CompletableFuture<ExecutionResult> future = execution.execute(document, graphQLSchema, executionId, executionInput, instrumentationState);
        future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                log.error(String.format("Execution '%s' threw exception when executing : query : '%s'. variables '%s'", executionId, executionInput.getQuery(), executionInput.getVariables()), throwable);
            } else {
                int errorCount = result.getErrors().size();
                if (errorCount > 0) {
                    log.debug("Execution '{}' completed with '{}' errors", (Object)executionId, (Object)errorCount);
                } else {
                    log.debug("Execution '{}' completed with zero errors", (Object)executionId);
                }
            }
        });
        return future;
    }

    static /* synthetic */ ExecutionIdProvider access$600() {
        return DEFAULT_EXECUTION_ID_PROVIDER;
    }

    private static class ParseResult {
        private final Document document;
        private final Exception exception;

        private ParseResult(Document document, Exception exception) {
            this.document = document;
            this.exception = exception;
        }

        private boolean isFailure() {
            return this.document == null;
        }

        private Document getDocument() {
            return this.document;
        }

        private Exception getException() {
            return this.exception;
        }

        private static ParseResult of(Document document) {
            return new ParseResult(document, null);
        }

        private static ParseResult ofError(Exception e) {
            return new ParseResult(null, e);
        }
    }

    @PublicApi
    public static class Builder {
        private GraphQLSchema graphQLSchema;
        private ExecutionStrategy queryExecutionStrategy = new AsyncExecutionStrategy();
        private ExecutionStrategy mutationExecutionStrategy = new AsyncSerialExecutionStrategy();
        private ExecutionStrategy subscriptionExecutionStrategy = new SubscriptionExecutionStrategy();
        private ExecutionIdProvider idProvider = GraphQL.access$600();
        private Instrumentation instrumentation = SimpleInstrumentation.INSTANCE;
        private PreparsedDocumentProvider preparsedDocumentProvider = NoOpPreparsedDocumentProvider.INSTANCE;

        public Builder(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
        }

        public Builder schema(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = Assert.assertNotNull(graphQLSchema, "GraphQLSchema must be non null", new Object[0]);
            return this;
        }

        public Builder queryExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.queryExecutionStrategy = Assert.assertNotNull(executionStrategy, "Query ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder mutationExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.mutationExecutionStrategy = Assert.assertNotNull(executionStrategy, "Mutation ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder subscriptionExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.subscriptionExecutionStrategy = Assert.assertNotNull(executionStrategy, "Subscription ExecutionStrategy must be non null", new Object[0]);
            return this;
        }

        public Builder instrumentation(Instrumentation instrumentation) {
            this.instrumentation = Assert.assertNotNull(instrumentation, "Instrumentation must be non null", new Object[0]);
            return this;
        }

        public Builder preparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = Assert.assertNotNull(preparsedDocumentProvider, "PreparsedDocumentProvider must be non null", new Object[0]);
            return this;
        }

        public Builder executionIdProvider(ExecutionIdProvider executionIdProvider) {
            this.idProvider = Assert.assertNotNull(executionIdProvider, "ExecutionIdProvider must be non null", new Object[0]);
            return this;
        }

        public GraphQL build() {
            Assert.assertNotNull(this.graphQLSchema, "queryStrategy must be non null", new Object[0]);
            Assert.assertNotNull(this.queryExecutionStrategy, "queryStrategy must be non null", new Object[0]);
            Assert.assertNotNull(this.idProvider, "idProvider must be non null", new Object[0]);
            return new GraphQL(this.graphQLSchema, this.queryExecutionStrategy, this.mutationExecutionStrategy, this.subscriptionExecutionStrategy, this.idProvider, this.instrumentation, this.preparsedDocumentProvider);
        }
    }
}

