/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.PublicApi;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class ExecutionInput {
    private final String query;
    private final String operationName;
    private final Object context;
    private final Object root;
    private final Map<String, Object> variables;

    public ExecutionInput(String query, String operationName, Object context, Object root, Map<String, Object> variables) {
        this.query = query;
        this.operationName = operationName;
        this.context = context;
        this.root = root;
        this.variables = variables;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getRoot() {
        return this.root;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public ExecutionInput transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder().query(this.query).operationName(this.operationName).context(this.context).root(this.root).variables(this.variables);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return "ExecutionInput{query='" + this.query + '\'' + ", operationName='" + this.operationName + '\'' + ", context=" + this.context + ", root=" + this.root + ", variables=" + this.variables + '}';
    }

    public static Builder newExecutionInput() {
        return new Builder();
    }

    public static class Builder {
        private String query;
        private String operationName;
        private Object context;
        private Object root;
        private Map<String, Object> variables = Collections.emptyMap();

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        public Builder root(Object root) {
            this.root = root;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public ExecutionInput build() {
            return new ExecutionInput(this.query, this.operationName, this.context, this.root, this.variables);
        }
    }
}

