/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.jaeger;

import io.grpc.BindableService;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.apache.skywalking.aop.server.receiver.jaeger.JaegerGRPCHandler;
import org.apache.skywalking.aop.server.receiver.jaeger.JaegerReceiverConfig;
import org.apache.skywalking.aop.server.receiver.jaeger.JaegerReceiverModule;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;

public class JaegerReceiverProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private JaegerReceiverConfig config;
    private GRPCServer grpcServer = null;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return JaegerReceiverModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        this.config = new JaegerReceiverConfig();
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        if (this.config.getGRPCPort() > 0) {
            this.grpcServer = new GRPCServer(Strings.isBlank((String)this.config.getGRPCHost()) ? "0.0.0.0" : this.config.getGRPCHost(), this.config.getGRPCPort());
            if (this.config.getMaxMessageSize() > 0) {
                this.grpcServer.setMaxMessageSize(this.config.getMaxMessageSize());
            }
            if (this.config.getMaxConcurrentCallsPerConnection() > 0) {
                this.grpcServer.setMaxConcurrentCallsPerConnection(this.config.getMaxConcurrentCallsPerConnection());
            }
            this.grpcServer.initialize();
        }
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        CoreRegisterLinker.setModuleManager((ModuleManager)this.getManager());
        SourceReceiver sourceReceiver = (SourceReceiver)this.getManager().find("core").provider().getService(SourceReceiver.class);
        if (Objects.nonNull(this.grpcServer)) {
            this.grpcServer.addHandler((BindableService)new JaegerGRPCHandler(sourceReceiver, this.config));
        } else {
            GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
            grpcHandlerRegister.addHandler((BindableService)new JaegerGRPCHandler(sourceReceiver, this.config));
        }
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        try {
            if (Objects.nonNull(this.grpcServer)) {
                this.grpcServer.start();
            }
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] requiredModules() {
        return new String[]{"receiver-sharing-server"};
    }
}

