/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.aop.server.receiver.jaeger;

import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import io.jaegertracing.api_v2.Collector;
import io.jaegertracing.api_v2.CollectorServiceGrpc;
import io.jaegertracing.api_v2.Model;
import java.time.Instant;
import java.util.Base64;
import org.apache.skywalking.aop.server.receiver.jaeger.JaegerReceiverConfig;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;
import org.apache.skywalking.oap.server.storage.plugin.jaeger.JaegerSpan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaegerGRPCHandler
extends CollectorServiceGrpc.CollectorServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(JaegerGRPCHandler.class);
    private SourceReceiver receiver;
    private JaegerReceiverConfig config;

    public JaegerGRPCHandler(SourceReceiver receiver, JaegerReceiverConfig config) {
        this.receiver = receiver;
        this.config = config;
    }

    public void postSpans(Collector.PostSpansRequest request, StreamObserver<Collector.PostSpansResponse> responseObserver) {
        request.getBatch().getSpansList().forEach(span -> {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(span.toString());
                }
                JaegerSpan jaegerSpan = new JaegerSpan();
                jaegerSpan.setTraceId(this.format(span.getTraceId()));
                jaegerSpan.setSpanId(this.format(span.getSpanId()));
                Model.Process process = span.getProcess();
                int serviceId = 0;
                String serviceName = null;
                if (process != null) {
                    serviceName = process.getServiceName();
                }
                if (StringUtil.isEmpty(serviceName)) {
                    serviceName = "UNKNOWN";
                }
                if ((serviceId = CoreRegisterLinker.getServiceInventoryCache().getServiceId(serviceName)) != 0) {
                    jaegerSpan.setServiceId(serviceId);
                } else {
                    JsonObject properties = new JsonObject();
                    if (process != null) {
                        process.getTagsList().forEach(keyValue -> {
                            String key = keyValue.getKey();
                            Model.ValueType valueVType = keyValue.getVType();
                            switch (valueVType) {
                                case STRING: {
                                    properties.addProperty(key, keyValue.getVStr());
                                    break;
                                }
                                case INT64: {
                                    properties.addProperty(key, (Number)keyValue.getVInt64());
                                    break;
                                }
                                case BOOL: {
                                    properties.addProperty(key, Boolean.valueOf(keyValue.getVBool()));
                                    break;
                                }
                                case FLOAT64: {
                                    properties.addProperty(key, (Number)keyValue.getVFloat64());
                                }
                            }
                        });
                    }
                    CoreRegisterLinker.getServiceInventoryRegister().getOrCreate(serviceName, properties);
                }
                long duration = span.getDuration().getNanos() / 1000000;
                jaegerSpan.setStartTime(Instant.ofEpochSecond(span.getStartTime().getSeconds(), span.getStartTime().getNanos()).toEpochMilli());
                long timeBucket = TimeBucket.getSecondTimeBucket((long)jaegerSpan.getStartTime());
                jaegerSpan.setTimeBucket(timeBucket);
                jaegerSpan.setEndTime(jaegerSpan.getStartTime() + duration);
                jaegerSpan.setLatency((int)duration);
                jaegerSpan.setDataBinary(span.toByteArray());
                jaegerSpan.setEndpointName(span.getOperationName());
                int finalServiceId = serviceId;
                span.getTagsList().forEach(tag -> {
                    String kind;
                    String key = tag.getKey();
                    if ("error".equals(key)) {
                        boolean status = tag.getVBool();
                        jaegerSpan.setIsError(BooleanUtils.booleanToValue((Boolean)status));
                    } else if ("span.kind".equals(key) && ("server".equals(kind = tag.getVStr()) || "consumer".equals(kind))) {
                        String endpointName = span.getOperationName();
                        jaegerSpan.setEndpointName(endpointName);
                        int endpointId = CoreRegisterLinker.getEndpointInventoryCache().getEndpointId(finalServiceId, endpointName, DetectPoint.SERVER.ordinal());
                        if (endpointId != 0) {
                            CoreRegisterLinker.getEndpointInventoryRegister().getOrCreate(finalServiceId, endpointName, DetectPoint.SERVER);
                        }
                    }
                });
                this.receiver.receive((Source)jaegerSpan);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        responseObserver.onNext((Object)Collector.PostSpansResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    private String format(ByteString bytes) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(bytes.toByteArray());
    }
}

