/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.etcd;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.ClusterModuleEtcdConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.Address;
import org.apache.skywalking.oap.server.library.util.ConnectStringParseException;
import org.apache.skywalking.oap.server.library.util.ConnectUtils;

public class EtcdUtils {
    public static List<URI> parse(ClusterModuleEtcdConfig config) throws ModuleStartException {
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            List addressList = ConnectUtils.parse((String)config.getHostPort());
            for (Address address : addressList) {
                uris.add(URI.create("http://" + address.getHost() + ":" + address.getPort()));
            }
        }
        catch (ConnectStringParseException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        return uris;
    }
}

