/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.etcd;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.ClusterModuleEtcdConfig;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.EtcdEndpoint;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;

public class EtcdCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private ClusterModuleEtcdConfig config;
    private EtcdClient client;
    private volatile Address selfAddress;
    private final String serviceName;
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private static final Integer KEY_TTL = 45;

    public EtcdCoordinator(ClusterModuleEtcdConfig config, EtcdClient client) {
        this.config = config;
        this.client = client;
        this.serviceName = config.getServiceName();
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> res = new ArrayList<RemoteInstance>();
        try {
            EtcdKeysResponse response = (EtcdKeysResponse)this.client.get(this.serviceName + "/").send().get();
            List nodes = response.getNode().getNodes();
            Gson gson = new Gson();
            if (nodes != null) {
                nodes.forEach(node -> {
                    EtcdEndpoint endpoint = (EtcdEndpoint)gson.fromJson(node.getValue(), EtcdEndpoint.class);
                    res.add(new RemoteInstance(new Address(endpoint.getHost(), endpoint.getPort(), true)));
                });
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        if (this.needUsingInternalAddr()) {
            remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
        }
        this.selfAddress = remoteInstance.getAddress();
        EtcdEndpoint endpoint = new EtcdEndpoint.Builder().serviceName(this.serviceName).host(this.selfAddress.getHost()).port(this.selfAddress.getPort()).build();
        try {
            this.client.putDir(this.serviceName).send();
            String key = this.buildKey(this.serviceName, this.selfAddress, remoteInstance);
            String json = new Gson().toJson((Object)endpoint);
            EtcdResponsePromise promise = this.client.put(key, json).ttl(KEY_TTL).send();
            promise.get();
            this.renew(this.client, key, json);
        }
        catch (Exception e) {
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    private void renew(EtcdClient client, String key, String json) {
        this.service.scheduleAtFixedRate(() -> {
            try {
                client.refresh(key, KEY_TTL).send().get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 5000L, 30000L, TimeUnit.MILLISECONDS);
    }

    private String buildKey(String serviceName, Address address, RemoteInstance instance) {
        return serviceName + "/" + address.getHost() + "_" + instance.hashCode();
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }
}

