/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.etcd;

import java.net.URI;
import java.util.List;
import mousio.etcd4j.EtcdClient;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.ClusterModuleEtcdConfig;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.EtcdCoordinator;
import org.apache.skywalking.oap.server.cluster.plugin.etcd.EtcdUtils;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class ClusterModuleEtcdProvider
extends ModuleProvider {
    private final ClusterModuleEtcdConfig config = new ClusterModuleEtcdConfig();
    private EtcdClient client;

    public String name() {
        return "etcd";
    }

    public Class<? extends ModuleDefine> module() {
        return ClusterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        List<URI> uris = EtcdUtils.parse(this.config);
        this.client = new EtcdClient(uris.toArray(new URI[0]));
        EtcdCoordinator coordinator = new EtcdCoordinator(this.config, this.client);
        this.registerServiceImplementation(ClusterRegister.class, (Service)coordinator);
        this.registerServiceImplementation(ClusterNodesQuery.class, (Service)coordinator);
    }

    public void start() throws ServiceNotProvidedException {
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

