/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider.grpc;

import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.exporter.ExporterModule;
import org.apache.skywalking.oap.server.core.exporter.MetricValuesExportService;
import org.apache.skywalking.oap.server.exporter.provider.grpc.GRPCExporter;
import org.apache.skywalking.oap.server.exporter.provider.grpc.GRPCExporterSetting;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleServiceHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class GRPCExporterProvider
extends ModuleProvider {
    private GRPCExporterSetting setting;
    private GRPCExporter exporter;

    public String name() {
        return "grpc";
    }

    public Class<? extends ModuleDefine> module() {
        return ExporterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        this.setting = new GRPCExporterSetting();
        return this.setting;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.exporter = new GRPCExporter(this.setting);
        this.registerServiceImplementation(MetricValuesExportService.class, (Service)this.exporter);
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        ModuleServiceHolder serviceHolder = this.getManager().find("core").provider();
        this.exporter.setServiceInventoryCache((ServiceInventoryCache)serviceHolder.getService(ServiceInventoryCache.class));
        this.exporter.setServiceInstanceInventoryCache((ServiceInstanceInventoryCache)serviceHolder.getService(ServiceInstanceInventoryCache.class));
        this.exporter.setEndpointInventoryCache((EndpointInventoryCache)serviceHolder.getService(EndpointInventoryCache.class));
        this.exporter.initSubscriptionList();
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

