/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider;

import org.apache.skywalking.oap.server.core.analysis.metrics.MetricsMetaInfo;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;

public class MetricFormatter {
    private ServiceInventoryCache serviceInventoryCache;
    private ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;

    protected String getEntityName(MetricsMetaInfo meta) {
        int scope = meta.getScope();
        if (DefaultScopeDefine.inServiceCatalog((int)scope)) {
            int entityId = Integer.valueOf(meta.getId());
            return this.serviceInventoryCache.get(entityId).getName();
        }
        if (DefaultScopeDefine.inServiceInstanceCatalog((int)scope)) {
            int entityId = Integer.valueOf(meta.getId());
            return this.serviceInstanceInventoryCache.get(entityId).getName();
        }
        if (DefaultScopeDefine.inEndpointCatalog((int)scope)) {
            int entityId = Integer.valueOf(meta.getId());
            return this.endpointInventoryCache.get(entityId).getName();
        }
        if (scope == 0) {
            return "";
        }
        return null;
    }

    public void setServiceInventoryCache(ServiceInventoryCache serviceInventoryCache) {
        this.serviceInventoryCache = serviceInventoryCache;
    }

    public void setServiceInstanceInventoryCache(ServiceInstanceInventoryCache serviceInstanceInventoryCache) {
        this.serviceInstanceInventoryCache = serviceInstanceInventoryCache;
    }

    public void setEndpointInventoryCache(EndpointInventoryCache endpointInventoryCache) {
        this.endpointInventoryCache = endpointInventoryCache;
    }
}

