/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.trace.ignore.matcher;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.skywalking.apm.plugin.trace.ignore.matcher.TracePathMatcher;
import org.apache.skywalking.apm.util.StringUtil;

public class AntPathMatcher
implements TracePathMatcher {
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final String ANY_ONE_MATCHING_CHAR = "?";
    private static final String ANY_MATCHING_CHAR = "*";
    private static final String MULTILEVEL_DIRECTORIES_ANY_MATCHING_CHAR = "*".concat("*");

    @Override
    public boolean match(String pattern, String path) {
        String resolvedPattern;
        int pathIdxStart;
        if (!MatchAssist.checkPatternAndPath(pattern, path)) {
            return false;
        }
        String[] resolvedPatterns = MatchAssist.resolvePath(pattern);
        String[] resolvedPaths = MatchAssist.resolvePath(path);
        int patternIdxStart = 0;
        int patternIdxEnd = resolvedPatterns.length - 1;
        int pathIdxEnd = resolvedPaths.length - 1;
        for (pathIdxStart = 0; patternIdxStart <= patternIdxEnd && pathIdxStart <= pathIdxEnd && !MULTILEVEL_DIRECTORIES_ANY_MATCHING_CHAR.equals(resolvedPattern = resolvedPatterns[patternIdxStart]); ++patternIdxStart, ++pathIdxStart) {
            if (MatchAssist.matchStrings(resolvedPattern, resolvedPaths[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (patternIdxStart > patternIdxEnd) {
                return pattern.endsWith(DEFAULT_PATH_SEPARATOR) == path.endsWith(DEFAULT_PATH_SEPARATOR);
            }
            return patternIdxStart == patternIdxEnd && resolvedPatterns[patternIdxStart].equals(ANY_MATCHING_CHAR) && path.endsWith(DEFAULT_PATH_SEPARATOR) || MatchAssist.checkPatternIdx(patternIdxStart, patternIdxEnd, resolvedPatterns);
        }
        if (patternIdxStart > patternIdxEnd) {
            return false;
        }
        while (patternIdxStart <= patternIdxEnd && pathIdxStart <= pathIdxEnd && !(resolvedPattern = resolvedPatterns[patternIdxEnd]).equals(MULTILEVEL_DIRECTORIES_ANY_MATCHING_CHAR)) {
            if (!MatchAssist.matchStrings(resolvedPattern, resolvedPaths[pathIdxEnd])) {
                return false;
            }
            --patternIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            return MatchAssist.checkPatternIdx(patternIdxStart, patternIdxEnd, resolvedPatterns);
        }
        while (patternIdxStart != patternIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patternIdxStart + 1; i <= patternIdxEnd; ++i) {
                if (!resolvedPatterns[i].equals(MULTILEVEL_DIRECTORIES_ANY_MATCHING_CHAR)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patternIdxStart + 1) {
                ++patternIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patternIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block4: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = resolvedPatterns[patternIdxStart + j + 1];
                    String subStr = resolvedPatterns[pathIdxStart + i + j];
                    if (!MatchAssist.matchStrings(subPat, subStr)) continue block4;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patternIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        return MatchAssist.checkPatternIdx(patternIdxStart, patternIdxEnd, resolvedPatterns);
    }

    private static class MatchAssist {
        private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
        private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
        private static final ConcurrentMap<String, Pattern> GLOBAL_COMPILED_PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();

        private MatchAssist() {
        }

        private static boolean checkPatternIdx(int patternIdxStart, int patternIdxEnd, String[] resolvedPatterns) {
            for (int i = patternIdxStart; i <= patternIdxEnd; ++i) {
                if (resolvedPatterns[i].equals(MULTILEVEL_DIRECTORIES_ANY_MATCHING_CHAR)) continue;
                return false;
            }
            return true;
        }

        private static boolean checkPatternAndPath(String pattern, String path) {
            return !StringUtil.isEmpty((String)pattern) && !StringUtil.isEmpty((String)path) && path.startsWith(AntPathMatcher.DEFAULT_PATH_SEPARATOR) == pattern.startsWith(AntPathMatcher.DEFAULT_PATH_SEPARATOR);
        }

        private static String[] resolvePath(String path) {
            if (path == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(path, AntPathMatcher.DEFAULT_PATH_SEPARATOR);
            ArrayList<String> tokens = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ((token = token.trim()).length() <= 0) continue;
                tokens.add(token);
            }
            return tokens.toArray(new String[tokens.size()]);
        }

        private static boolean matchStrings(String pattern, String path) {
            if (StringUtil.isEmpty((String)pattern) || StringUtil.isEmpty((String)path)) {
                return false;
            }
            Pattern compliedPattern = (Pattern)GLOBAL_COMPILED_PATTERN_CACHE.get(pattern);
            if (compliedPattern == null) {
                StringBuilder patternBuilder = new StringBuilder();
                Matcher matcher = GLOB_PATTERN.matcher(pattern);
                int end = 0;
                while (matcher.find()) {
                    patternBuilder.append(MatchAssist.quote(pattern, end, matcher.start()));
                    String match = matcher.group();
                    if (AntPathMatcher.ANY_ONE_MATCHING_CHAR.equals(match)) {
                        patternBuilder.append('.');
                    } else if (AntPathMatcher.ANY_MATCHING_CHAR.equals(match)) {
                        patternBuilder.append(".".concat(AntPathMatcher.ANY_MATCHING_CHAR));
                    } else if (match.startsWith("{") && match.endsWith("}")) {
                        int colonIdx = match.indexOf(58);
                        if (colonIdx == -1) {
                            patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                        } else {
                            String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                            patternBuilder.append('(');
                            patternBuilder.append(variablePattern);
                            patternBuilder.append(')');
                        }
                    }
                    end = matcher.end();
                }
                patternBuilder.append(MatchAssist.quote(pattern, end, pattern.length()));
                compliedPattern = Pattern.compile(patternBuilder.toString());
                GLOBAL_COMPILED_PATTERN_CACHE.putIfAbsent(pattern, compliedPattern);
            }
            return compliedPattern.matcher(path).matches();
        }

        private static String quote(String s, int start, int end) {
            if (start == end) {
                return "";
            }
            return Pattern.quote(s.substring(start, end));
        }
    }
}

