/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.trace.ignore;

import org.apache.skywalking.apm.agent.core.boot.AgentPackageNotFoundException;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.conf.ConfigNotFoundException;
import org.apache.skywalking.apm.agent.core.context.AbstractTracerContext;
import org.apache.skywalking.apm.agent.core.context.ContextManagerExtendService;
import org.apache.skywalking.apm.agent.core.context.IgnoredTracerContext;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.trace.ignore.conf.IgnoreConfig;
import org.apache.skywalking.apm.plugin.trace.ignore.conf.IgnoreConfigInitializer;
import org.apache.skywalking.apm.plugin.trace.ignore.matcher.AntPathMatcher;
import org.apache.skywalking.apm.plugin.trace.ignore.matcher.TracePathMatcher;
import org.apache.skywalking.apm.util.StringUtil;

@OverrideImplementor(value=ContextManagerExtendService.class)
public class TraceIgnoreExtendService
extends ContextManagerExtendService {
    private static final ILog LOGGER = LogManager.getLogger(TraceIgnoreExtendService.class);
    private static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final String PATTERN_SEPARATOR = ",";
    private TracePathMatcher pathMatcher = new AntPathMatcher();

    public void boot() {
        try {
            IgnoreConfigInitializer.initialize();
        }
        catch (ConfigNotFoundException e) {
            LOGGER.error("trace ignore config init error", (Throwable)e);
        }
        catch (AgentPackageNotFoundException e) {
            LOGGER.error("trace ignore config init error", (Throwable)e);
        }
    }

    public AbstractTracerContext createTraceContext(String operationName, boolean forceSampling) {
        String pattens = IgnoreConfig.Trace.IGNORE_PATH;
        if (!StringUtil.isEmpty((String)pattens) && !forceSampling) {
            String path = operationName;
            if (!StringUtil.isEmpty((String)path) && path.length() > 1 && path.endsWith(DEFAULT_PATH_SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            for (String pattern : pattens.split(PATTERN_SEPARATOR)) {
                if (!this.pathMatcher.match(pattern, path)) continue;
                LOGGER.debug("operationName : " + operationName + " Ignore tracking");
                return new IgnoredTracerContext();
            }
        }
        return super.createTraceContext(operationName, forceSampling);
    }
}

