/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.webflux.v5;

import io.netty.handler.codec.http.HttpRequest;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.EnhanceRequireObjectCache;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor.StackDepth;

public abstract class AbstractMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public abstract String getRequestURL(Method var1);

    public abstract String getAcceptedMethodTypes(Method var1);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpRequest request;
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return;
        }
        EnhanceRequireObjectCache pathMappingCache = (EnhanceRequireObjectCache)objInst.getSkyWalkingDynamicField();
        String requestURL = pathMappingCache.findPathMapping(method);
        if (requestURL == null) {
            requestURL = this.getRequestURL(method);
            pathMappingCache.addPathMapping(method, requestURL);
            requestURL = this.getAcceptedMethodTypes(method) + pathMappingCache.findPathMapping(method);
        }
        if ((request = (HttpRequest)ContextManager.getRuntimeContext().get((Object)"SW_WEBFLUX_REQUEST_KEY")) != null) {
            StackDepth stackDepth = (StackDepth)ContextManager.getRuntimeContext().get((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
            if (stackDepth == null) {
                ContextCarrier contextCarrier = new ContextCarrier();
                CarrierItem next = contextCarrier.items();
                while (next.hasNext()) {
                    next = next.next();
                    next.setHeadValue(request.headers().get(next.getHeadKey()));
                }
                AbstractSpan span = ContextManager.createEntrySpan((String)requestURL, (ContextCarrier)contextCarrier);
                Tags.URL.set(span, request.uri());
                Tags.HTTP.METHOD.set(span, request.method().name());
                span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
                SpanLayer.asHttp((AbstractSpan)span);
                stackDepth = new StackDepth();
            } else {
                AbstractSpan span = ContextManager.createLocalSpan((String)(objInst.getClass().getName() + "/" + method.getName()));
                span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
            }
            stackDepth.increment();
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return ret;
        }
        HttpRequest request = (HttpRequest)ContextManager.getRuntimeContext().get((Object)"SW_WEBFLUX_REQUEST_KEY");
        if (request != null) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

