/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.ttl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.IModelGetter;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataTTLKeeperTimer {
    INSTANCE;

    private static final Logger logger;
    private ModuleManager moduleManager;
    private ClusterNodesQuery clusterNodesQuery;

    public void start(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.clusterNodesQuery = (ClusterNodesQuery)moduleManager.find("cluster").provider().getService(ClusterNodesQuery.class);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(this::delete, t -> logger.error("Remove data in background failure.", t)), 5L, 5L, TimeUnit.MINUTES);
    }

    private void delete() {
        List<RemoteInstance> remoteInstances = this.clusterNodesQuery.queryRemoteNodes();
        if (CollectionUtils.isNotEmpty(remoteInstances) && !remoteInstances.get(0).getAddress().isSelf()) {
            logger.info("The selected first getAddress is {}. Skip.", (Object)remoteInstances.get(0).toString());
            return;
        }
        logger.info("Beginning to remove expired metrics from the storage.");
        IModelGetter modelGetter = (IModelGetter)this.moduleManager.find("core").provider().getService(IModelGetter.class);
        List<Model> models = modelGetter.getModels();
        models.forEach(model -> {
            if (model.isDeleteHistory()) {
                this.execute((Model)model);
            }
        });
    }

    private void execute(Model model) {
        try {
            ((IHistoryDeleteDAO)this.moduleManager.find("storage").provider().getService(IHistoryDeleteDAO.class)).deleteHistory(model, "time_bucket");
        }
        catch (IOException e) {
            logger.warn("History of {} delete failure", (Object)model.getName());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(DataTTLKeeperTimer.class);
    }
}

