/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnIds;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.IModelGetter;
import org.apache.skywalking.oap.server.core.storage.model.IModelOverride;
import org.apache.skywalking.oap.server.core.storage.model.IModelSetter;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageModels
implements IModelGetter,
IModelSetter,
IModelOverride {
    private static final Logger logger = LoggerFactory.getLogger(StorageModels.class);
    private final List<Model> models = new LinkedList<Model>();

    @Override
    public Model putIfAbsent(Class aClass, int scopeId, Storage storage) {
        Model model2;
        DefaultScopeDefine.nameOf(scopeId);
        for (Model model2 : this.models) {
            if (!model2.getName().equals(storage.getModelName())) continue;
            return model2;
        }
        LinkedList<ModelColumn> modelColumns = new LinkedList<ModelColumn>();
        this.retrieval(aClass, storage.getModelName(), modelColumns);
        model2 = new Model(storage.getModelName(), modelColumns, storage.isCapableOfTimeSeries(), storage.isDeleteHistory(), scopeId, storage.getDownsampling());
        this.models.add(model2);
        return model2;
    }

    private void retrieval(Class clazz, String modelName, List<ModelColumn> modelColumns) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            Column column = field.getAnnotation(Column.class);
            modelColumns.add(new ModelColumn(new ColumnName(column.columnName()), field.getType(), column.matchQuery(), column.content()));
            if (logger.isDebugEnabled()) {
                logger.debug("The field named {} with the {} type", (Object)column.columnName(), field.getType());
            }
            if (!column.isValue()) continue;
            ValueColumnIds.INSTANCE.putIfAbsent(modelName, column.columnName(), column.function());
        }
        if (Objects.nonNull(clazz.getSuperclass())) {
            this.retrieval(clazz.getSuperclass(), modelName, modelColumns);
        }
    }

    @Override
    public void overrideColumnName(String columnName, String newName) {
        this.models.forEach(model -> model.getColumns().forEach(column -> {
            ColumnName existColumnName = column.getColumnName();
            String name = existColumnName.getName();
            if (name.equals(columnName)) {
                existColumnName.setStorageName(newName);
                logger.debug("Model {} column {} has been override. The new column name is {}.", new Object[]{model.getName(), name, newName});
            }
        }));
    }

    @Override
    public List<Model> getModels() {
        return this.models;
    }
}

