/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.util.List;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.IModelGetter;
import org.apache.skywalking.oap.server.core.storage.model.IModelOverride;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelInstaller {
    private static final Logger logger = LoggerFactory.getLogger(ModelInstaller.class);
    private final ModuleManager moduleManager;

    public ModelInstaller(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public final void install(Client client) throws StorageException {
        IModelGetter modelGetter = (IModelGetter)this.moduleManager.find("core").provider().getService(IModelGetter.class);
        List<Model> models = modelGetter.getModels();
        if (RunningMode.isNoInitMode()) {
            for (Model model : models) {
                while (!this.isExists(client, model)) {
                    try {
                        logger.info("table: {} does not exist. OAP is running in 'no-init' mode, waiting... retry 3s later.", (Object)model.getName());
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
        } else {
            for (Model model : models) {
                if (this.isExists(client, model)) continue;
                logger.info("table: {} does not exist", (Object)model.getName());
                this.createTable(client, model);
            }
        }
    }

    public final void overrideColumnName(String columnName, String newName) {
        IModelOverride modelOverride = (IModelOverride)this.moduleManager.find("core").provider().getService(IModelOverride.class);
        modelOverride.overrideColumnName(columnName, newName);
    }

    protected abstract boolean isExists(Client var1, Model var2) throws StorageException;

    protected abstract void createTable(Client var1, Model var2) throws StorageException;
}

