/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;

public class Model {
    private final String name;
    private final boolean capableOfTimeSeries;
    private final Downsampling downsampling;
    private final boolean deleteHistory;
    private final List<ModelColumn> columns;
    private final int scopeId;

    public Model(String name, List<ModelColumn> columns, boolean capableOfTimeSeries, boolean deleteHistory, int scopeId, Downsampling downsampling) {
        this.columns = columns;
        this.capableOfTimeSeries = capableOfTimeSeries;
        this.downsampling = downsampling;
        this.deleteHistory = deleteHistory;
        this.scopeId = scopeId;
        this.name = ModelName.build(downsampling, name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCapableOfTimeSeries() {
        return this.capableOfTimeSeries;
    }

    public Downsampling getDownsampling() {
        return this.downsampling;
    }

    public boolean isDeleteHistory() {
        return this.deleteHistory;
    }

    public List<ModelColumn> getColumns() {
        return this.columns;
    }

    public int getScopeId() {
        return this.scopeId;
    }
}

