/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PersistenceTimer {
    INSTANCE;

    private static final Logger logger;
    private Boolean isStarted = false;
    private final Boolean debug = System.getProperty("debug") != null;
    private CounterMetrics errorCounter;
    private HistogramMetrics prepareLatency;
    private HistogramMetrics executeLatency;

    public void start(ModuleManager moduleManager) {
        logger.info("persistence timer start");
        long timeInterval = 3L;
        IBatchDAO batchDAO = (IBatchDAO)moduleManager.find("storage").provider().getService(IBatchDAO.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.errorCounter = metricsCreator.createCounter("persistence_timer_bulk_error_count", "Error execution of the prepare stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.prepareLatency = metricsCreator.createHistogramMetric("persistence_timer_bulk_prepare_latency", "Latency of the prepare stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        this.executeLatency = metricsCreator.createHistogramMetric("persistence_timer_bulk_execute_latency", "Latency of the execute stage in persistence timer", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        if (!this.isStarted.booleanValue()) {
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(() -> this.extractDataAndSave(batchDAO), t -> logger.error("Extract data and save failure.", t)), 1L, 3L, TimeUnit.SECONDS);
            this.isStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractDataAndSave(IBatchDAO batchDAO) {
        if (logger.isDebugEnabled()) {
            logger.debug("Extract data and save");
        }
        long startTime = System.currentTimeMillis();
        try {
            HistogramMetrics.Timer timer = this.prepareLatency.createTimer();
            LinkedList batchAllCollection = new LinkedList();
            try {
                ArrayList<PersistenceWorker> persistenceWorkers = new ArrayList<PersistenceWorker>();
                persistenceWorkers.addAll(MetricsStreamProcessor.getInstance().getPersistentWorkers());
                persistenceWorkers.addAll(RecordStreamProcessor.getInstance().getPersistentWorkers());
                persistenceWorkers.addAll(TopNStreamProcessor.getInstance().getPersistentWorkers());
                persistenceWorkers.forEach(worker -> {
                    if (logger.isDebugEnabled()) {
                        logger.debug("extract {} worker data and save", (Object)worker.getClass().getName());
                    }
                    if (worker.flushAndSwitch()) {
                        List<?> batchCollection = worker.buildBatchCollection();
                        if (logger.isDebugEnabled()) {
                            logger.debug("extract {} worker data size: {}", (Object)worker.getClass().getName(), (Object)batchCollection.size());
                        }
                        batchAllCollection.addAll(batchCollection);
                    }
                });
                if (this.debug.booleanValue()) {
                    logger.info("build batch persistence duration: {} ms", (Object)(System.currentTimeMillis() - startTime));
                }
            }
            finally {
                timer.finish();
            }
            HistogramMetrics.Timer executeLatencyTimer = this.executeLatency.createTimer();
            try {
                batchDAO.batchPersistence(batchAllCollection);
            }
            finally {
                executeLatencyTimer.finish();
            }
        }
        catch (Throwable e) {
            this.errorCounter.inc();
            logger.error(e.getMessage(), e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("persistence data save finish");
            }
        }
        if (this.debug.booleanValue()) {
            logger.info("batch persistence duration: {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    static {
        logger = LoggerFactory.getLogger(PersistenceTimer.class);
    }
}

