/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.annotation.AnnotationListener;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;

public class DefaultScopeDefine {
    private static final Map<String, Integer> NAME_2_ID = new HashMap<String, Integer>();
    private static final Map<Integer, String> ID_2_NAME = new HashMap<Integer, String>();
    public static final int ALL = 0;
    public static final int SERVICE = 1;
    public static final int SERVICE_INSTANCE = 2;
    public static final int ENDPOINT = 3;
    public static final int SERVICE_RELATION = 4;
    public static final int SERVICE_INSTANCE_RELATION = 5;
    public static final int ENDPOINT_RELATION = 6;
    public static final int NETWORK_ADDRESS = 7;
    public static final int SERVICE_INSTANCE_JVM_CPU = 8;
    public static final int SERVICE_INSTANCE_JVM_MEMORY = 9;
    public static final int SERVICE_INSTANCE_JVM_MEMORY_POOL = 10;
    public static final int SERVICE_INSTANCE_JVM_GC = 11;
    public static final int SEGMENT = 12;
    public static final int ALARM = 13;
    public static final int SERVICE_INVENTORY = 14;
    public static final int SERVICE_INSTANCE_INVENTORY = 15;
    public static final int ENDPOINT_INVENTORY = 16;
    public static final int DATABASE_ACCESS = 17;
    public static final int DATABASE_SLOW_STATEMENT = 18;
    public static final int SERVICE_INSTANCE_CLR_CPU = 19;
    public static final int SERVICE_INSTANCE_CLR_GC = 20;
    public static final int SERVICE_INSTANCE_CLR_THREAD = 21;
    public static final int ENVOY_INSTANCE_METRIC = 22;
    public static final int ZIPKIN_SPAN = 23;
    public static final int JAEGER_SPAN = 24;
    public static final int HTTP_ACCESS_LOG = 25;
    public static final String SERVICE_CATALOG_NAME = "SERVICE";
    public static final String SERVICE_INSTANCE_CATALOG_NAME = "SERVICE_INSTANCE";
    public static final String ENDPOINT_CATALOG_NAME = "ENDPOINT";
    private static final Map<Integer, Boolean> SERVICE_CATALOG = new HashMap<Integer, Boolean>();
    private static final Map<Integer, Boolean> SERVICE_INSTANCE_CATALOG = new HashMap<Integer, Boolean>();
    private static final Map<Integer, Boolean> ENDPOINT_CATALOG = new HashMap<Integer, Boolean>();

    public static final void addNewScope(ScopeDeclaration declaration, Class originalClass) {
        String catalogName;
        int id = declaration.id();
        if (ID_2_NAME.containsKey(id)) {
            throw new UnexpectedException("ScopeDeclaration id=" + id + " at " + originalClass.getName() + " has conflict with another named " + ID_2_NAME.get(id));
        }
        String name = declaration.name();
        if (NAME_2_ID.containsKey(name)) {
            throw new UnexpectedException("ScopeDeclaration name=" + name + " at " + originalClass.getName() + " has conflict with another id= " + NAME_2_ID.get(name));
        }
        ID_2_NAME.put(id, name);
        NAME_2_ID.put(name, id);
        switch (catalogName = declaration.catalog()) {
            case "SERVICE": {
                SERVICE_CATALOG.put(id, Boolean.TRUE);
                break;
            }
            case "SERVICE_INSTANCE": {
                SERVICE_INSTANCE_CATALOG.put(id, Boolean.TRUE);
                break;
            }
            case "ENDPOINT": {
                ENDPOINT_CATALOG.put(id, Boolean.TRUE);
            }
        }
    }

    public static String nameOf(int id) {
        String name = ID_2_NAME.get(id);
        if (name == null) {
            throw new UnexpectedException("ScopeDefine id = " + id + " not found.");
        }
        return name;
    }

    public static int valueOf(String name) {
        Integer id = NAME_2_ID.get(name);
        if (id == null) {
            throw new UnexpectedException("ScopeDefine name = " + name + " not found.");
        }
        return id;
    }

    public static void reset() {
        NAME_2_ID.clear();
        ID_2_NAME.clear();
    }

    public static boolean inServiceCatalog(int scopeId) {
        return SERVICE_CATALOG.containsKey(scopeId);
    }

    public static boolean inServiceInstanceCatalog(int scopeId) {
        return SERVICE_INSTANCE_CATALOG.containsKey(scopeId);
    }

    public static boolean inEndpointCatalog(int scopeId) {
        return ENDPOINT_CATALOG.containsKey(scopeId);
    }

    public static class Listener
    implements AnnotationListener {
        @Override
        public Class<? extends Annotation> annotation() {
            return ScopeDeclaration.class;
        }

        @Override
        public void notify(Class originalClass) {
            ScopeDeclaration declaration = originalClass.getAnnotation(ScopeDeclaration.class);
            if (declaration != null) {
                DefaultScopeDefine.addNewScope(declaration, originalClass);
            }
        }
    }
}

