/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote.define;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingGetter;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingSetter;

public class StreamDataMapping
implements StreamDataMappingGetter,
StreamDataMappingSetter {
    private List<Class<? extends StreamData>> streamClassList = new ArrayList<Class<? extends StreamData>>();
    private final Map<Class<? extends StreamData>, Integer> classMap = new HashMap<Class<? extends StreamData>, Integer>();
    private final Map<Integer, Class<? extends StreamData>> idMap = new HashMap<Integer, Class<? extends StreamData>>();

    @Override
    public synchronized void putIfAbsent(Class<? extends StreamData> streamDataClass) {
        if (this.classMap.containsKey(streamDataClass)) {
            return;
        }
        this.streamClassList.add(streamDataClass);
    }

    public void init() {
        Collections.sort(this.streamClassList, new Comparator<Class>(){

            @Override
            public int compare(Class streamClass1, Class streamClass2) {
                return streamClass1.getName().compareTo(streamClass2.getName());
            }
        });
        for (int i = 0; i < this.streamClassList.size(); ++i) {
            Class<? extends StreamData> streamClass = this.streamClassList.get(i);
            int streamId = i + 1;
            this.classMap.put(streamClass, streamId);
            this.idMap.put(streamId, streamClass);
        }
    }

    @Override
    public int findIdByClass(Class<? extends StreamData> streamDataClass) {
        return this.classMap.get(streamDataClass);
    }

    @Override
    public Class<? extends StreamData> findClassById(int id) {
        return this.idMap.get(id);
    }
}

