/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote.client;

import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class SelfRemoteClient
implements RemoteClient {
    private final Address address;
    private CounterMetrics remoteOutCounter;
    private final IWorkerInstanceGetter workerInstanceGetter;

    public SelfRemoteClient(ModuleDefineHolder moduleDefineHolder, Address address) {
        this.address = address;
        this.workerInstanceGetter = (IWorkerInstanceGetter)moduleDefineHolder.find("core").provider().getService(IWorkerInstanceGetter.class);
        this.remoteOutCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_out_count", "The number(client side) of inside remote inside aggregate rpc.", new MetricsTag.Keys(new String[]{"dest", "self"}), new MetricsTag.Values(new String[]{address.toString(), "Y"}));
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void connect() {
    }

    @Override
    public void close() {
        throw new UnexpectedException("Self remote client invoked to close.");
    }

    @Override
    public void push(int nextWorkerId, StreamData streamData) {
        this.workerInstanceGetter.get(nextWorkerId).in(streamData);
    }

    @Override
    public int compareTo(RemoteClient o) {
        return this.address.compareTo(o.getAddress());
    }
}

