/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.GRPCRemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.SelfRemoteClient;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingGetter;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.telemetry.api.GaugeMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClientManager
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(RemoteClientManager.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private StreamDataMappingGetter streamDataMappingGetter;
    private ClusterNodesQuery clusterNodesQuery;
    private final List<RemoteClient> clientsA;
    private final List<RemoteClient> clientsB;
    private volatile List<RemoteClient> usingClients;
    private GaugeMetrics gauge;

    public RemoteClientManager(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
        this.clientsA = new LinkedList<RemoteClient>();
        this.clientsB = new LinkedList<RemoteClient>();
        this.usingClients = this.clientsA;
    }

    public void start() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::refresh, 1L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void refresh() {
        if (this.gauge == null) {
            this.gauge = ((MetricsCreator)this.moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("cluster_size", "Cluster size of current oap node", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
        try {
            Class<RemoteClientManager> clazz;
            if (Objects.isNull(this.clusterNodesQuery)) {
                clazz = RemoteClientManager.class;
                // MONITORENTER : org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager.class
                if (Objects.isNull(this.clusterNodesQuery)) {
                    this.clusterNodesQuery = (ClusterNodesQuery)this.moduleDefineHolder.find("cluster").provider().getService(ClusterNodesQuery.class);
                }
                // MONITOREXIT : clazz
            }
            if (Objects.isNull(this.streamDataMappingGetter)) {
                clazz = RemoteClientManager.class;
                // MONITORENTER : org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager.class
                if (Objects.isNull(this.streamDataMappingGetter)) {
                    this.streamDataMappingGetter = (StreamDataMappingGetter)this.moduleDefineHolder.find("core").provider().getService(StreamDataMappingGetter.class);
                }
                // MONITOREXIT : clazz
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Refresh remote nodes collection.");
            }
            List<RemoteInstance> instanceList = this.clusterNodesQuery.queryRemoteNodes();
            instanceList = this.distinct(instanceList);
            Collections.sort(instanceList);
            this.gauge.setValue((double)instanceList.size());
            if (logger.isDebugEnabled()) {
                instanceList.forEach(instance -> logger.debug("Cluster instance: {}", (Object)instance.toString()));
            }
            if (!this.compare(instanceList)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ReBuilding remote clients.");
                }
                this.reBuildRemoteClients(instanceList);
            }
            this.printRemoteClientList();
            return;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private void printRemoteClientList() {
        if (logger.isDebugEnabled()) {
            StringBuilder addresses = new StringBuilder();
            this.getRemoteClient().forEach(client -> addresses.append(client.getAddress().toString()).append(","));
            logger.debug("Remote client list: {}", (Object)addresses);
        }
    }

    private List<RemoteInstance> distinct(List<RemoteInstance> instanceList) {
        HashSet addresses = new HashSet();
        ArrayList<RemoteInstance> newInstanceList = new ArrayList<RemoteInstance>();
        instanceList.forEach(instance -> {
            if (addresses.add(instance.getAddress())) {
                newInstanceList.add((RemoteInstance)instance);
            }
        });
        return newInstanceList;
    }

    public List<RemoteClient> getRemoteClient() {
        return this.usingClients;
    }

    private List<RemoteClient> getFreeClients() {
        if (this.usingClients.equals(this.clientsA)) {
            return this.clientsB;
        }
        return this.clientsA;
    }

    private void switchCurrentClients() {
        this.usingClients = this.usingClients.equals(this.clientsA) ? this.clientsB : this.clientsA;
    }

    private synchronized void reBuildRemoteClients(List<RemoteInstance> remoteInstances) {
        this.getFreeClients().clear();
        HashMap remoteClients = new HashMap();
        this.getRemoteClient().forEach(client -> remoteClients.put(client.getAddress(), client));
        HashMap<Address, Action> tempRemoteClients = new HashMap<Address, Action>();
        this.getRemoteClient().forEach(client -> tempRemoteClients.put(client.getAddress(), Action.Close));
        remoteInstances.forEach(remoteInstance -> {
            if (tempRemoteClients.containsKey(remoteInstance.getAddress())) {
                tempRemoteClients.put(remoteInstance.getAddress(), Action.Leave);
            } else {
                tempRemoteClients.put(remoteInstance.getAddress(), Action.Create);
            }
        });
        tempRemoteClients.forEach((address, action) -> {
            switch (action) {
                case Leave: {
                    if (!remoteClients.containsKey(address)) break;
                    this.getFreeClients().add((RemoteClient)remoteClients.get(address));
                    break;
                }
                case Create: {
                    if (address.isSelf()) {
                        SelfRemoteClient client = new SelfRemoteClient(this.moduleDefineHolder, (Address)address);
                        this.getFreeClients().add(client);
                        break;
                    }
                    GRPCRemoteClient client = new GRPCRemoteClient(this.moduleDefineHolder, this.streamDataMappingGetter, (Address)address, 1, 3000);
                    client.connect();
                    this.getFreeClients().add(client);
                }
            }
        });
        Collections.sort(this.getFreeClients());
        this.switchCurrentClients();
        tempRemoteClients.forEach((address, action) -> {
            if (Action.Close.equals(action) && remoteClients.containsKey(address)) {
                ((RemoteClient)remoteClients.get(address)).close();
            }
        });
        this.getFreeClients().clear();
    }

    private boolean compare(List<RemoteInstance> remoteInstances) {
        if (this.usingClients.size() == remoteInstances.size()) {
            for (int i = 0; i < this.usingClients.size(); ++i) {
                if (this.usingClients.get(i).getAddress().equals(remoteInstances.get(i).getAddress())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static enum Action {
        Close,
        Leave,
        Create;

    }
}

