/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote;

import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingGetter;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.Empty;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteMessage;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteServiceGrpc;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceHandler
extends RemoteServiceGrpc.RemoteServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteServiceHandler.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private StreamDataMappingGetter streamDataMappingGetter;
    private IWorkerInstanceGetter workerInstanceGetter;
    private CounterMetrics remoteInCounter;
    private CounterMetrics remoteInErrorCounter;
    private HistogramMetrics remoteInHistogram;

    public RemoteServiceHandler(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
        this.remoteInCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_in_count", "The number(server side) of inside remote inside aggregate rpc.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.remoteInErrorCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_in_error_count", "The error number(server side) of inside remote inside aggregate rpc.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.remoteInHistogram = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createHistogramMetric("remote_in_latency", "The latency(server side) of inside remote inside aggregate rpc.", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public StreamObserver<RemoteMessage> call(final StreamObserver<Empty> responseObserver) {
        Class<RemoteServiceHandler> clazz;
        if (Objects.isNull(this.streamDataMappingGetter)) {
            clazz = RemoteServiceHandler.class;
            // MONITORENTER : org.apache.skywalking.oap.server.core.remote.RemoteServiceHandler.class
            if (Objects.isNull(this.streamDataMappingGetter)) {
                this.streamDataMappingGetter = (StreamDataMappingGetter)this.moduleDefineHolder.find("core").provider().getService(StreamDataMappingGetter.class);
            }
            // MONITOREXIT : clazz
        }
        if (!Objects.isNull(this.workerInstanceGetter)) return new StreamObserver<RemoteMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(RemoteMessage message) {
                RemoteServiceHandler.this.remoteInCounter.inc();
                HistogramMetrics.Timer timer = RemoteServiceHandler.this.remoteInHistogram.createTimer();
                try {
                    int streamDataId = message.getStreamDataId();
                    int nextWorkerId = message.getNextWorkerId();
                    RemoteData remoteData = message.getRemoteData();
                    Class<? extends StreamData> streamDataClass = RemoteServiceHandler.this.streamDataMappingGetter.findClassById(streamDataId);
                    try {
                        StreamData streamData = streamDataClass.newInstance();
                        streamData.deserialize(remoteData);
                        RemoteServiceHandler.this.workerInstanceGetter.get(nextWorkerId).in(streamData);
                    }
                    catch (Throwable t) {
                        RemoteServiceHandler.this.remoteInErrorCounter.inc();
                        logger.error(t.getMessage(), t);
                    }
                }
                finally {
                    timer.finish();
                }
            }

            public void onError(Throwable throwable) {
                logger.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Empty.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
        clazz = RemoteServiceHandler.class;
        // MONITORENTER : org.apache.skywalking.oap.server.core.remote.RemoteServiceHandler.class
        if (Objects.isNull(this.workerInstanceGetter)) {
            this.workerInstanceGetter = (IWorkerInstanceGetter)this.moduleDefineHolder.find("core").provider().getService(IWorkerInstanceGetter.class);
        }
        // MONITOREXIT : clazz
        return new /* invalid duplicate definition of identical inner class */;
    }
}

