/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote;

import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.remote.selector.ForeverFirstSelector;
import org.apache.skywalking.oap.server.core.remote.selector.HashCodeSelector;
import org.apache.skywalking.oap.server.core.remote.selector.RollingSelector;
import org.apache.skywalking.oap.server.core.remote.selector.Selector;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class RemoteSenderService
implements Service {
    private final ModuleManager moduleManager;
    private final HashCodeSelector hashCodeSelector;
    private final ForeverFirstSelector foreverFirstSelector;
    private final RollingSelector rollingSelector;

    public RemoteSenderService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.hashCodeSelector = new HashCodeSelector();
        this.foreverFirstSelector = new ForeverFirstSelector();
        this.rollingSelector = new RollingSelector();
    }

    public void send(int nextWorkId, StreamData streamData, Selector selector) {
        RemoteClientManager clientManager = (RemoteClientManager)this.moduleManager.find("core").provider().getService(RemoteClientManager.class);
        switch (selector) {
            case HashCode: {
                RemoteClient remoteClient = this.hashCodeSelector.select(clientManager.getRemoteClient(), streamData);
                remoteClient.push(nextWorkId, streamData);
                break;
            }
            case Rolling: {
                RemoteClient remoteClient = this.rollingSelector.select(clientManager.getRemoteClient(), streamData);
                remoteClient.push(nextWorkId, streamData);
                break;
            }
            case ForeverFirst: {
                RemoteClient remoteClient = this.foreverFirstSelector.select(clientManager.getRemoteClient(), streamData);
                remoteClient.push(nextWorkId, streamData);
            }
        }
    }
}

