/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.worker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.EndOfBatchContext;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.storage.IRegisterDAO;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterPersistentWorker
extends AbstractWorker<RegisterSource> {
    private static final Logger logger = LoggerFactory.getLogger(RegisterPersistentWorker.class);
    private final int scopeId;
    private final String modelName;
    private final Map<RegisterSource, RegisterSource> sources;
    private final IRegisterLockDAO registerLockDAO;
    private final IRegisterDAO registerDAO;
    private final DataCarrier<RegisterSource> dataCarrier;

    RegisterPersistentWorker(ModuleDefineHolder moduleDefineHolder, String modelName, IRegisterDAO registerDAO, int scopeId) {
        super(moduleDefineHolder);
        this.modelName = modelName;
        this.sources = new HashMap<RegisterSource, RegisterSource>();
        this.registerDAO = registerDAO;
        this.registerLockDAO = (IRegisterLockDAO)moduleDefineHolder.find("storage").provider().getService(IRegisterLockDAO.class);
        this.scopeId = scopeId;
        this.dataCarrier = new DataCarrier("MetricsPersistentWorker." + modelName, 1, 1000);
        String name = "REGISTER_L2";
        int size = BulkConsumePool.Creator.recommendMaxSize() / 8;
        if (size == 0) {
            size = 1;
        }
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, size, 200L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new PersistentConsumer(this));
    }

    @Override
    public final void in(RegisterSource registerSource) {
        registerSource.setEndOfBatchContext(new EndOfBatchContext(false));
        this.dataCarrier.produce((Object)registerSource);
    }

    private void onWork(RegisterSource registerSource) {
        if (!this.sources.containsKey(registerSource)) {
            this.sources.put(registerSource, registerSource);
        } else {
            this.sources.get(registerSource).combine(registerSource);
        }
        if (this.sources.size() > 1000 || registerSource.getEndOfBatchContext().isEndOfBatch()) {
            this.sources.values().forEach(source -> {
                block9: {
                    try {
                        RegisterSource dbSource = this.registerDAO.get(this.modelName, source.id());
                        if (Objects.nonNull(dbSource)) {
                            if (dbSource.combine((RegisterSource)source)) {
                                this.registerDAO.forceUpdate(this.modelName, dbSource);
                            }
                            break block9;
                        }
                        int sequence = this.registerLockDAO.getId(this.scopeId, (RegisterSource)source);
                        if (sequence != 0) {
                            try {
                                dbSource = this.registerDAO.get(this.modelName, source.id());
                                if (Objects.nonNull(dbSource)) {
                                    if (dbSource.combine((RegisterSource)source)) {
                                        this.registerDAO.forceUpdate(this.modelName, dbSource);
                                    }
                                    break block9;
                                }
                                source.setSequence(sequence);
                                this.registerDAO.forceInsert(this.modelName, (RegisterSource)source);
                            }
                            catch (Throwable t) {
                                logger.error(t.getMessage(), t);
                            }
                            break block9;
                        }
                        logger.info("{} inventory register try lock and increment sequence failure.", (Object)DefaultScopeDefine.nameOf(this.scopeId));
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            });
            this.sources.clear();
        }
    }

    private class PersistentConsumer
    implements IConsumer<RegisterSource> {
        private final RegisterPersistentWorker persistent;

        private PersistentConsumer(RegisterPersistentWorker persistent) {
            this.persistent = persistent;
        }

        public void init() {
        }

        public void consume(List<RegisterSource> data) {
            Iterator<RegisterSource> sourceIterator = data.iterator();
            int i = 0;
            while (sourceIterator.hasNext()) {
                RegisterSource registerSource = sourceIterator.next();
                if (++i == data.size()) {
                    registerSource.getEndOfBatchContext().setEndOfBatch(true);
                }
                this.persistent.onWork(registerSource);
            }
        }

        public void onError(List<RegisterSource> data, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

