/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.worker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.skywalking.apm.commons.datacarrier.DataCarrier;
import org.apache.skywalking.apm.commons.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.apm.commons.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.apm.commons.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.data.EndOfBatchContext;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterDistinctWorker
extends AbstractWorker<RegisterSource> {
    private static final Logger logger = LoggerFactory.getLogger(RegisterDistinctWorker.class);
    private final AbstractWorker<RegisterSource> nextWorker;
    private final DataCarrier<RegisterSource> dataCarrier;
    private final Map<RegisterSource, RegisterSource> sources;
    private int messageNum;

    RegisterDistinctWorker(ModuleDefineHolder moduleDefineHolder, AbstractWorker<RegisterSource> nextWorker) {
        super(moduleDefineHolder);
        this.nextWorker = nextWorker;
        this.sources = new HashMap<RegisterSource, RegisterSource>();
        this.dataCarrier = new DataCarrier(1, 1000);
        String name = "REGISTER_L1";
        int size = BulkConsumePool.Creator.recommendMaxSize() / 8;
        if (size == 0) {
            size = 1;
        }
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, size, 200L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new AggregatorConsumer(this));
    }

    @Override
    public final void in(RegisterSource source) {
        source.setEndOfBatchContext(new EndOfBatchContext(false));
        this.dataCarrier.produce((Object)source);
    }

    private void onWork(RegisterSource source) {
        block6: {
            block5: {
                ++this.messageNum;
                if (!this.sources.containsKey(source)) {
                    this.sources.put(source, source);
                } else {
                    this.sources.get(source).combine(source);
                }
                if (this.messageNum >= 1000) break block5;
                if (!source.getEndOfBatchContext().isEndOfBatch()) break block6;
            }
            this.sources.values().forEach(this.nextWorker::in);
            this.sources.clear();
            this.messageNum = 0;
        }
    }

    private class AggregatorConsumer
    implements IConsumer<RegisterSource> {
        private final RegisterDistinctWorker aggregator;

        private AggregatorConsumer(RegisterDistinctWorker aggregator) {
            this.aggregator = aggregator;
        }

        public void init() {
        }

        public void consume(List<RegisterSource> sources) {
            Iterator<RegisterSource> sourceIterator = sources.iterator();
            int i = 0;
            while (sourceIterator.hasNext()) {
                RegisterSource source = sourceIterator.next();
                if (++i == sources.size()) {
                    source.getEndOfBatchContext().setEndOfBatch(true);
                }
                this.aggregator.onWork(source);
            }
        }

        public void onError(List<RegisterSource> sources, Throwable t) {
            logger.error(t.getMessage(), t);
        }

        public void onExit() {
        }
    }
}

