/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.StreamProcessor;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.register.worker.RegisterDistinctWorker;
import org.apache.skywalking.oap.server.core.register.worker.RegisterPersistentWorker;
import org.apache.skywalking.oap.server.core.register.worker.RegisterRemoteWorker;
import org.apache.skywalking.oap.server.core.remote.define.StreamDataMappingSetter;
import org.apache.skywalking.oap.server.core.storage.IRegisterDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.annotation.Storage;
import org.apache.skywalking.oap.server.core.storage.model.IModelSetter;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;

public class InventoryStreamProcessor
implements StreamProcessor<RegisterSource> {
    private static final InventoryStreamProcessor PROCESSOR = new InventoryStreamProcessor();
    private Map<Class<? extends RegisterSource>, RegisterDistinctWorker> entryWorkers = new HashMap<Class<? extends RegisterSource>, RegisterDistinctWorker>();

    public static InventoryStreamProcessor getInstance() {
        return PROCESSOR;
    }

    @Override
    public void in(RegisterSource registerSource) {
        this.entryWorkers.get(registerSource.getClass()).in(registerSource);
    }

    @Override
    public void create(ModuleDefineHolder moduleDefineHolder, Stream stream, Class<? extends RegisterSource> inventoryClass) {
        IRegisterDAO registerDAO;
        StorageDAO storageDAO = (StorageDAO)moduleDefineHolder.find("storage").provider().getService(StorageDAO.class);
        try {
            registerDAO = storageDAO.newRegisterDao(stream.builder().newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UnexpectedException("Create " + stream.builder().getSimpleName() + " register DAO failure.", e);
        }
        IModelSetter modelSetter = (IModelSetter)moduleDefineHolder.find("core").provider().getService(IModelSetter.class);
        Model model = modelSetter.putIfAbsent(inventoryClass, stream.scopeId(), new Storage(stream.name(), false, false, Downsampling.None));
        StreamDataMappingSetter streamDataMappingSetter = (StreamDataMappingSetter)moduleDefineHolder.find("core").provider().getService(StreamDataMappingSetter.class);
        streamDataMappingSetter.putIfAbsent(inventoryClass);
        RegisterPersistentWorker persistentWorker = new RegisterPersistentWorker(moduleDefineHolder, model.getName(), registerDAO, stream.scopeId());
        RegisterRemoteWorker remoteWorker = new RegisterRemoteWorker(moduleDefineHolder, persistentWorker);
        RegisterDistinctWorker distinctWorker = new RegisterDistinctWorker(moduleDefineHolder, remoteWorker);
        this.entryWorkers.put(inventoryClass, distinctWorker);
    }

    public List<Class> getAllRegisterSources() {
        ArrayList<Class> allSources = new ArrayList<Class>();
        this.entryWorkers.keySet().forEach(allSources::add);
        return allSources;
    }
}

