/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.service;

import com.google.gson.JsonObject;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInventoryRegister
implements IServiceInventoryRegister {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInventoryRegister.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private ServiceInventoryCache serviceInventoryCache;

    public ServiceInventoryRegister(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
    }

    private ServiceInventoryCache getServiceInventoryCache() {
        if (Objects.isNull(this.serviceInventoryCache)) {
            this.serviceInventoryCache = (ServiceInventoryCache)this.moduleDefineHolder.find("core").provider().getService(ServiceInventoryCache.class);
        }
        return this.serviceInventoryCache;
    }

    @Override
    public int getOrCreate(String serviceName, JsonObject properties) {
        int serviceId = this.getServiceInventoryCache().getServiceId(serviceName);
        if (serviceId == 0) {
            ServiceInventory serviceInventory = new ServiceInventory();
            serviceInventory.setName(serviceName);
            serviceInventory.setAddressId(0);
            serviceInventory.setIsAddress(0);
            long now = System.currentTimeMillis();
            serviceInventory.setRegisterTime(now);
            serviceInventory.setHeartbeatTime(now);
            serviceInventory.setMappingServiceId(0);
            serviceInventory.setMappingLastUpdateTime(now);
            serviceInventory.setProperties(properties);
            InventoryStreamProcessor.getInstance().in(serviceInventory);
        }
        return serviceId;
    }

    @Override
    public int getOrCreate(int addressId, String serviceName, JsonObject properties) {
        int serviceId = this.getServiceInventoryCache().getServiceId(addressId);
        if (serviceId == 0) {
            ServiceInventory serviceInventory = new ServiceInventory();
            serviceInventory.setName(serviceName);
            serviceInventory.setAddressId(addressId);
            serviceInventory.setIsAddress(1);
            long now = System.currentTimeMillis();
            serviceInventory.setRegisterTime(now);
            serviceInventory.setHeartbeatTime(now);
            serviceInventory.setMappingLastUpdateTime(now);
            InventoryStreamProcessor.getInstance().in(serviceInventory);
        }
        return serviceId;
    }

    @Override
    public void update(int serviceId, NodeType nodeType, JsonObject properties) {
        ServiceInventory serviceInventory = this.getServiceInventoryCache().get(serviceId);
        if (Objects.nonNull(serviceInventory)) {
            if (properties != null || !this.compare(serviceInventory, nodeType)) {
                serviceInventory = serviceInventory.getClone();
                serviceInventory.setServiceNodeType(nodeType);
                serviceInventory.setProperties(properties);
                serviceInventory.setMappingLastUpdateTime(System.currentTimeMillis());
                InventoryStreamProcessor.getInstance().in(serviceInventory);
            }
        } else {
            logger.warn("Service {} nodeType/properties update, but not found in storage.", (Object)serviceId);
        }
    }

    @Override
    public void heartbeat(int serviceId, long heartBeatTime) {
        ServiceInventory serviceInventory = this.getServiceInventoryCache().get(serviceId);
        if (Objects.nonNull(serviceInventory)) {
            serviceInventory = serviceInventory.getClone();
            serviceInventory.setHeartbeatTime(heartBeatTime);
            InventoryStreamProcessor.getInstance().in(serviceInventory);
        } else {
            logger.warn("Service {} heartbeat, but not found in storage.", (Object)serviceId);
        }
    }

    @Override
    public void updateMapping(int serviceId, int mappingServiceId) {
        ServiceInventory serviceInventory = this.getServiceInventoryCache().get(serviceId);
        if (Objects.nonNull(serviceInventory)) {
            serviceInventory = serviceInventory.getClone();
            serviceInventory.setMappingServiceId(mappingServiceId);
            serviceInventory.setMappingLastUpdateTime(System.currentTimeMillis());
            InventoryStreamProcessor.getInstance().in(serviceInventory);
        } else {
            logger.warn("Service {} mapping update, but not found in storage.", (Object)serviceId);
        }
    }

    private boolean compare(ServiceInventory newServiceInventory, NodeType nodeType) {
        if (Objects.nonNull(newServiceInventory)) {
            return nodeType.equals((Object)newServiceInventory.getServiceNodeType());
        }
        return true;
    }
}

