/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.service;

import com.google.gson.JsonObject;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceInventoryRegister
implements IServiceInstanceInventoryRegister {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceInventoryRegister.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private ServiceInstanceInventoryCache serviceInstanceInventoryCache;

    public ServiceInstanceInventoryRegister(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
    }

    private ServiceInstanceInventoryCache getServiceInstanceInventoryCache() {
        if (Objects.isNull(this.serviceInstanceInventoryCache)) {
            this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)this.moduleDefineHolder.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        }
        return this.serviceInstanceInventoryCache;
    }

    @Override
    public int getOrCreate(int serviceId, String serviceInstanceName, String uuid, long registerTime, JsonObject properties) {
        int serviceInstanceId;
        if (logger.isDebugEnabled()) {
            logger.debug("Get or create service instance by service instance name, service id: {}, service instance name: {},uuid: {}, registerTime: {}", new Object[]{serviceId, serviceInstanceName, uuid, registerTime});
        }
        if ((serviceInstanceId = this.getServiceInstanceInventoryCache().getServiceInstanceId(serviceId, uuid)) == 0) {
            ServiceInstanceInventory serviceInstanceInventory = new ServiceInstanceInventory();
            serviceInstanceInventory.setServiceId(serviceId);
            serviceInstanceInventory.setName(serviceInstanceName);
            serviceInstanceInventory.setInstanceUUID(uuid);
            serviceInstanceInventory.setIsAddress(0);
            serviceInstanceInventory.setAddressId(0);
            serviceInstanceInventory.setRegisterTime(registerTime);
            serviceInstanceInventory.setHeartbeatTime(registerTime);
            serviceInstanceInventory.setProperties(properties);
            InventoryStreamProcessor.getInstance().in(serviceInstanceInventory);
        }
        return serviceInstanceId;
    }

    @Override
    public int getOrCreate(int serviceId, int addressId, long registerTime) {
        int serviceInstanceId;
        if (logger.isDebugEnabled()) {
            logger.debug("get or create service instance by getAddress id, service id: {}, getAddress id: {}, registerTime: {}", new Object[]{serviceId, addressId, registerTime});
        }
        if ((serviceInstanceId = this.getServiceInstanceInventoryCache().getServiceInstanceId(serviceId, addressId)) == 0) {
            ServiceInstanceInventory serviceInstanceInventory = new ServiceInstanceInventory();
            serviceInstanceInventory.setServiceId(serviceId);
            serviceInstanceInventory.setName("");
            serviceInstanceInventory.setIsAddress(1);
            serviceInstanceInventory.setAddressId(addressId);
            serviceInstanceInventory.setRegisterTime(registerTime);
            serviceInstanceInventory.setHeartbeatTime(registerTime);
            InventoryStreamProcessor.getInstance().in(serviceInstanceInventory);
        }
        return serviceInstanceId;
    }

    @Override
    public void heartbeat(int serviceInstanceId, long heartBeatTime) {
        ServiceInstanceInventory serviceInstanceInventory = this.getServiceInstanceInventoryCache().get(serviceInstanceId);
        if (Objects.nonNull(serviceInstanceInventory)) {
            serviceInstanceInventory.setHeartbeatTime(heartBeatTime);
            InventoryStreamProcessor.getInstance().in(serviceInstanceInventory);
        } else {
            logger.warn("Service instance {} heartbeat, but not found in storage.", (Object)serviceInstanceId);
        }
    }
}

