/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.service;

import com.google.gson.JsonObject;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressInventoryCache;
import org.apache.skywalking.oap.server.core.register.NetworkAddressInventory;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressInventoryRegister
implements INetworkAddressInventoryRegister {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAddressInventoryRegister.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private NetworkAddressInventoryCache networkAddressInventoryCache;
    private IServiceInventoryRegister serviceInventoryRegister;
    private IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;

    public NetworkAddressInventoryRegister(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
    }

    private NetworkAddressInventoryCache getNetworkAddressInventoryCache() {
        if (Objects.isNull(this.networkAddressInventoryCache)) {
            this.networkAddressInventoryCache = (NetworkAddressInventoryCache)this.moduleDefineHolder.find("core").provider().getService(NetworkAddressInventoryCache.class);
        }
        return this.networkAddressInventoryCache;
    }

    private IServiceInventoryRegister getServiceInventoryRegister() {
        if (Objects.isNull(this.serviceInventoryRegister)) {
            this.serviceInventoryRegister = (IServiceInventoryRegister)this.moduleDefineHolder.find("core").provider().getService(IServiceInventoryRegister.class);
        }
        return this.serviceInventoryRegister;
    }

    private IServiceInstanceInventoryRegister getServiceInstanceInventoryRegister() {
        if (Objects.isNull(this.serviceInstanceInventoryRegister)) {
            this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)this.moduleDefineHolder.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
        }
        return this.serviceInstanceInventoryRegister;
    }

    @Override
    public int getOrCreate(String networkAddress, JsonObject properties) {
        int addressId = this.getNetworkAddressInventoryCache().getAddressId(networkAddress);
        if (addressId != 0) {
            int serviceInstanceId;
            int serviceId = this.getServiceInventoryRegister().getOrCreate(addressId, networkAddress, properties);
            if (serviceId != 0 && (serviceInstanceId = this.getServiceInstanceInventoryRegister().getOrCreate(serviceId, addressId, System.currentTimeMillis())) != 0) {
                return addressId;
            }
        } else {
            NetworkAddressInventory newNetworkAddress = new NetworkAddressInventory();
            newNetworkAddress.setName(networkAddress);
            long now = System.currentTimeMillis();
            newNetworkAddress.setRegisterTime(now);
            newNetworkAddress.setHeartbeatTime(now);
            InventoryStreamProcessor.getInstance().in(newNetworkAddress);
        }
        return 0;
    }

    @Override
    public int get(String networkAddress) {
        return this.getNetworkAddressInventoryCache().getAddressId(networkAddress);
    }

    @Override
    public void heartbeat(int addressId, long heartBeatTime) {
        NetworkAddressInventory networkAddress = this.getNetworkAddressInventoryCache().get(addressId);
        if (Objects.nonNull(networkAddress)) {
            networkAddress = networkAddress.getClone();
            networkAddress.setHeartbeatTime(heartBeatTime);
            InventoryStreamProcessor.getInstance().in(networkAddress);
        } else {
            logger.warn("Network getAddress {} heartbeat, but not found in storage.", (Object)addressId);
        }
    }

    @Override
    public void update(int addressId, NodeType nodeType) {
        NetworkAddressInventory networkAddress = this.getNetworkAddressInventoryCache().get(addressId);
        if (!this.compare(networkAddress, nodeType)) {
            NetworkAddressInventory newNetworkAddress = networkAddress.getClone();
            newNetworkAddress.setNetworkAddressNodeType(nodeType);
            newNetworkAddress.setHeartbeatTime(System.currentTimeMillis());
            InventoryStreamProcessor.getInstance().in(newNetworkAddress);
        }
    }

    private boolean compare(NetworkAddressInventory newNetworkAddress, NodeType nodeType) {
        if (Objects.nonNull(newNetworkAddress)) {
            return nodeType.equals((Object)newNetworkAddress.getNetworkAddressNodeType());
        }
        return true;
    }
}

