/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register.service;

import java.util.Objects;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.register.EndpointInventory;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointInventoryRegister
implements IEndpointInventoryRegister {
    private static final Logger logger = LoggerFactory.getLogger(EndpointInventoryRegister.class);
    private final ModuleDefineHolder moduleDefineHolder;
    private EndpointInventoryCache cacheService;

    public EndpointInventoryRegister(ModuleDefineHolder moduleDefineHolder) {
        this.moduleDefineHolder = moduleDefineHolder;
    }

    private EndpointInventoryCache getCacheService() {
        if (Objects.isNull(this.cacheService)) {
            this.cacheService = (EndpointInventoryCache)this.moduleDefineHolder.find("core").provider().getService(EndpointInventoryCache.class);
        }
        return this.cacheService;
    }

    @Override
    public int getOrCreate(int serviceId, String endpointName, DetectPoint detectPoint) {
        int endpointId = this.getCacheService().getEndpointId(serviceId, endpointName, detectPoint.ordinal());
        if (endpointId == 0) {
            EndpointInventory endpointInventory = new EndpointInventory();
            endpointInventory.setServiceId(serviceId);
            endpointInventory.setName(endpointName);
            endpointInventory.setDetectPoint(detectPoint.ordinal());
            long now = System.currentTimeMillis();
            endpointInventory.setRegisterTime(now);
            endpointInventory.setHeartbeatTime(now);
            InventoryStreamProcessor.getInstance().in(endpointInventory);
        }
        return endpointId;
    }

    @Override
    public int get(int serviceId, String endpointName, int detectPoint) {
        return this.getCacheService().getEndpointId(serviceId, endpointName, detectPoint);
    }

    @Override
    public void heartbeat(int endpointId, long heartBeatTime) {
        EndpointInventory endpointInventory = this.getCacheService().get(endpointId);
        if (Objects.nonNull(endpointInventory)) {
            endpointInventory.setHeartbeatTime(heartBeatTime);
            InventoryStreamProcessor.getInstance().in(endpointInventory);
        } else {
            logger.warn("Endpoint {} heartbeat, but not found in storage.", (Object)endpointId);
        }
    }
}

