/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.register;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.elasticsearch.common.Strings;

@ScopeDeclaration(id=14, name="ServiceInventory")
@Stream(name="service_inventory", scopeId=14, builder=Builder.class, processor=InventoryStreamProcessor.class)
public class ServiceInventory
extends RegisterSource {
    public static final String INDEX_NAME = "service_inventory";
    public static final String NAME = "name";
    public static final String IS_ADDRESS = "is_address";
    private static final String ADDRESS_ID = "address_id";
    public static final String NODE_TYPE = "node_type";
    public static final String MAPPING_SERVICE_ID = "mapping_service_id";
    public static final String MAPPING_LAST_UPDATE_TIME = "mapping_last_update_time";
    public static final String PROPERTIES = "properties";
    private static final Gson GSON = new Gson();
    @Column(columnName="name", matchQuery=true)
    private String name = "";
    @Column(columnName="is_address")
    private int isAddress;
    @Column(columnName="address_id")
    private int addressId;
    @Column(columnName="node_type")
    private int nodeType;
    @Column(columnName="mapping_service_id")
    private int mappingServiceId;
    @Column(columnName="mapping_last_update_time")
    private long mappingLastUpdateTime;
    @Column(columnName="properties")
    private String prop;
    private JsonObject properties;

    public NodeType getServiceNodeType() {
        return NodeType.get(this.nodeType);
    }

    public static String buildId(String serviceName) {
        return serviceName + "_" + 0 + "_" + 0;
    }

    public static String buildId(int addressId) {
        return "1_" + addressId;
    }

    public void setServiceNodeType(NodeType nodeType) {
        this.nodeType = nodeType.value();
    }

    @Override
    public String id() {
        if (1 == this.isAddress) {
            return ServiceInventory.buildId(this.addressId);
        }
        return ServiceInventory.buildId(this.name);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.isAddress;
        result = 31 * result + this.addressId;
        return result;
    }

    public void setProperties(JsonObject properties) {
        this.properties = properties;
        if (properties != null && properties.keySet().size() > 0) {
            this.prop = properties.toString();
        }
    }

    private void setProp(String prop) {
        this.prop = prop;
        if (!Strings.isNullOrEmpty((String)prop)) {
            this.properties = (JsonObject)GSON.fromJson(prop, JsonObject.class);
        }
    }

    public boolean hasProperties() {
        return this.prop != null && this.prop.length() > 0;
    }

    public ServiceInventory getClone() {
        ServiceInventory inventory = new ServiceInventory();
        inventory.setSequence(this.getSequence());
        inventory.setRegisterTime(this.getRegisterTime());
        inventory.setHeartbeatTime(this.getHeartbeatTime());
        inventory.setName(this.name);
        inventory.setIsAddress(this.isAddress);
        inventory.setNodeType(this.nodeType);
        inventory.setAddressId(this.addressId);
        inventory.setMappingLastUpdateTime(this.mappingLastUpdateTime);
        inventory.setMappingServiceId(this.mappingServiceId);
        inventory.setProp(this.prop);
        return inventory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInventory source = (ServiceInventory)obj;
        if (!this.name.equals(source.getName())) {
            return false;
        }
        if (this.isAddress != source.getIsAddress()) {
            return false;
        }
        return this.addressId == source.getAddressId();
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataIntegers(this.getSequence());
        remoteBuilder.addDataIntegers(this.isAddress);
        remoteBuilder.addDataIntegers(this.addressId);
        remoteBuilder.addDataIntegers(this.mappingServiceId);
        remoteBuilder.addDataIntegers(this.nodeType);
        remoteBuilder.addDataLongs(this.getRegisterTime());
        remoteBuilder.addDataLongs(this.getHeartbeatTime());
        remoteBuilder.addDataLongs(this.getMappingLastUpdateTime());
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.name) ? "" : this.name);
        remoteBuilder.addDataStrings(Strings.isNullOrEmpty((String)this.prop) ? "" : this.prop);
        return remoteBuilder;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setSequence(remoteData.getDataIntegers(0));
        this.setIsAddress(remoteData.getDataIntegers(1));
        this.setAddressId(remoteData.getDataIntegers(2));
        this.setMappingServiceId(remoteData.getDataIntegers(3));
        this.setNodeType(remoteData.getDataIntegers(4));
        this.setRegisterTime(remoteData.getDataLongs(0));
        this.setHeartbeatTime(remoteData.getDataLongs(1));
        this.setMappingLastUpdateTime(remoteData.getDataLongs(2));
        this.setName(remoteData.getDataStrings(0));
        this.setProp(remoteData.getDataStrings(1));
    }

    @Override
    public int remoteHashCode() {
        return 0;
    }

    @Override
    public boolean combine(RegisterSource registerSource) {
        super.combine(registerSource);
        ServiceInventory serviceInventory = (ServiceInventory)registerSource;
        this.nodeType = serviceInventory.nodeType;
        this.setProp(serviceInventory.getProp());
        if (0 != serviceInventory.getMappingServiceId() && serviceInventory.getMappingLastUpdateTime() >= this.getMappingLastUpdateTime()) {
            this.mappingServiceId = serviceInventory.getMappingServiceId();
            this.mappingLastUpdateTime = serviceInventory.getMappingLastUpdateTime();
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIsAddress(int isAddress) {
        this.isAddress = isAddress;
    }

    public int getIsAddress() {
        return this.isAddress;
    }

    public void setAddressId(int addressId) {
        this.addressId = addressId;
    }

    public int getAddressId() {
        return this.addressId;
    }

    private void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    private int getNodeType() {
        return this.nodeType;
    }

    public void setMappingServiceId(int mappingServiceId) {
        this.mappingServiceId = mappingServiceId;
    }

    public int getMappingServiceId() {
        return this.mappingServiceId;
    }

    public void setMappingLastUpdateTime(long mappingLastUpdateTime) {
        this.mappingLastUpdateTime = mappingLastUpdateTime;
    }

    public long getMappingLastUpdateTime() {
        return this.mappingLastUpdateTime;
    }

    private String getProp() {
        return this.prop;
    }

    public JsonObject getProperties() {
        return this.properties;
    }

    public static class Builder
    implements StorageBuilder<ServiceInventory> {
        @Override
        public ServiceInventory map2Data(Map<String, Object> dbMap) {
            ServiceInventory inventory = new ServiceInventory();
            inventory.setSequence((Integer)dbMap.get("sequence"));
            inventory.setIsAddress((Integer)dbMap.get(ServiceInventory.IS_ADDRESS));
            inventory.setMappingServiceId((Integer)dbMap.get(ServiceInventory.MAPPING_SERVICE_ID));
            inventory.setName((String)dbMap.get(ServiceInventory.NAME));
            inventory.setAddressId((Integer)dbMap.get(ServiceInventory.ADDRESS_ID));
            inventory.setNodeType((Integer)dbMap.get(ServiceInventory.NODE_TYPE));
            inventory.setRegisterTime((Long)dbMap.get("register_time"));
            inventory.setHeartbeatTime((Long)dbMap.get("heartbeat_time"));
            inventory.setMappingLastUpdateTime((Long)dbMap.get(ServiceInventory.MAPPING_LAST_UPDATE_TIME));
            inventory.setProp((String)dbMap.get(ServiceInventory.PROPERTIES));
            return inventory;
        }

        @Override
        public Map<String, Object> data2Map(ServiceInventory storageData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sequence", storageData.getSequence());
            map.put(ServiceInventory.IS_ADDRESS, storageData.getIsAddress());
            map.put(ServiceInventory.MAPPING_SERVICE_ID, storageData.getMappingServiceId());
            map.put(ServiceInventory.NAME, storageData.getName());
            map.put(ServiceInventory.ADDRESS_ID, storageData.getAddressId());
            map.put(ServiceInventory.NODE_TYPE, storageData.getNodeType());
            map.put("register_time", storageData.getRegisterTime());
            map.put("heartbeat_time", storageData.getHeartbeatTime());
            map.put(ServiceInventory.MAPPING_LAST_UPDATE_TIME, storageData.getMappingLastUpdateTime());
            map.put(ServiceInventory.PROPERTIES, storageData.getProp());
            return map;
        }
    }

    public static class PropertyUtil {
        public static final String DATABASE = "database";
    }
}

